/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.codec;

import com.tvd12.ezyfox.codec.EzyMessageByTypeSerializer;
import com.tvd12.ezyfox.function.EzyParser;
import com.tvd12.ezyfox.io.EzyMaps;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class EzyAbstractByTypeSerializer
implements EzyMessageByTypeSerializer {
    protected Map<Class<?>, Map<Class<?>, EzyParser>> parserMaps = this.defaultParserMaps();

    @Override
    public <T> T serialize(Object value, Class<T> outType) {
        return value == null ? this.parseNil(outType) : this.parseNotNull(value, outType);
    }

    protected <T> T parseNotNull(Object value, Class<T> outType) {
        Map<Class<?>, EzyParser<Object, Object>> parsers = this.getParserMap(value.getClass());
        if (parsers == null) {
            return this.parseWithNoParsers(value, outType);
        }
        EzyParser<Object, Object> parser = parsers.get(outType);
        if (parser == null) {
            return this.parseWithNoParser(value, outType);
        }
        return this.parseWithParser(parser, value);
    }

    protected <T> T parseWithParser(EzyParser<Object, Object> parser, Object value) {
        return (T)parser.parse(value);
    }

    protected <T> T parseWithNoParsers(Object value, Class<T> outType) {
        throw new IllegalArgumentException("has no parse for " + value.getClass());
    }

    protected <T> T parseWithNoParser(Object value, Class<T> outType) {
        throw new IllegalArgumentException("has no parse for " + value.getClass() + " and outType " + outType);
    }

    protected abstract <T> T parseNil(Class<T> var1);

    protected Map<Class<?>, EzyParser<Object, Object>> getParserMap(Class<?> type) {
        return (Map)EzyMaps.getValue(this.parserMaps, type);
    }

    protected Map<Class<?>, Map<Class<?>, EzyParser>> defaultParserMaps() {
        ConcurrentHashMap map = new ConcurrentHashMap();
        this.addParserMap(map);
        return map;
    }

    protected abstract void addParserMap(Map<Class<?>, Map<Class<?>, EzyParser>> var1);
}

