/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.bean.impl;

import com.tvd12.ezyfox.asm.EzyFunction;
import com.tvd12.ezyfox.asm.EzyInstruction;
import com.tvd12.ezyfox.bean.EzyBeanContext;
import com.tvd12.ezyfox.bean.EzyPrototypeFactory;
import com.tvd12.ezyfox.bean.EzyPrototypeSupplier;
import com.tvd12.ezyfox.bean.impl.EzyKeyValueParser;
import com.tvd12.ezyfox.bean.impl.EzyPrototypeSupplierLoader;
import com.tvd12.ezyfox.bean.impl.EzySimpleObjectBuilder;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.reflect.EzyClass;
import com.tvd12.ezyfox.reflect.EzyClasses;
import com.tvd12.ezyfox.reflect.EzyField;
import com.tvd12.ezyfox.reflect.EzyMethod;
import com.tvd12.ezyfox.reflect.EzyReflectElement;
import com.tvd12.ezyfox.reflect.EzySetterMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtNewMethod;
import lombok.Generated;

public abstract class EzySimplePrototypeSupplierLoader
extends EzySimpleObjectBuilder
implements EzyPrototypeSupplierLoader {
    private static final AtomicInteger COUNT = new AtomicInteger(0);
    private static boolean debug;

    public EzySimplePrototypeSupplierLoader(String beanName, EzyClass clazz) {
        super(beanName, clazz);
    }

    @Override
    public final EzyPrototypeSupplier load(EzyPrototypeFactory factory) {
        try {
            return this.process(factory);
        }
        catch (Throwable e) {
            throw new IllegalStateException("can not create prototype supplier of class " + this.clazz, e);
        }
    }

    private Class<?> getPrototypeClass() {
        return this.clazz.getClazz();
    }

    protected Map getAnnotationProperties() {
        return EzyKeyValueParser.getPrototypeProperties(this.getPrototypeClass());
    }

    private EzyPrototypeSupplier process(EzyPrototypeFactory factory) throws Exception {
        ClassPool pool = ClassPool.getDefault();
        String implClassName = this.getImplClassName();
        CtClass implClass = pool.makeClass(implClassName);
        EzyMethod supplyMethod = this.getSupplyMethod();
        supplyMethod.setDisplayName("supply$impl");
        String supplyImplMethodContent = this.makeSupplyImplMethodContent(supplyMethod);
        supplyMethod.setDisplayName("supply");
        String supplyMethodContent = this.makeSupplyMethodContent(supplyMethod);
        EzyMethod getObjectTypeMethod = this.getGetObjectTypeMethod();
        String getObjectTypeMethodContent = this.makeGetObjectTypeMethodContent(getObjectTypeMethod);
        this.printMethodContent(supplyMethodContent);
        this.printMethodContent(supplyImplMethodContent);
        this.printMethodContent(getObjectTypeMethodContent);
        implClass.setInterfaces(new CtClass[]{pool.makeClass(EzyPrototypeSupplier.class.getName())});
        implClass.addMethod(CtNewMethod.make((String)supplyImplMethodContent, (CtClass)implClass));
        implClass.addMethod(CtNewMethod.make((String)supplyMethodContent, (CtClass)implClass));
        implClass.addMethod(CtNewMethod.make((String)getObjectTypeMethodContent, (CtClass)implClass));
        Class answerClass = implClass.toClass();
        implClass.detach();
        EzyPrototypeSupplier supplier = (EzyPrototypeSupplier)EzyClasses.newInstance((Class)answerClass);
        factory.addSupplier(this.beanName, supplier, this.getAnnotationProperties());
        this.logger.debug("add prototype supplier of {}", (Object)implClassName);
        return supplier;
    }

    private String makeGetObjectTypeMethodContent(EzyMethod method) {
        return new EzyFunction(method).body().append(new EzyInstruction("\t", "\n").answer().clazz(this.clazz.getClazz(), true)).function().toString();
    }

    private String makeSupplyMethodContent(EzyMethod method) {
        return new EzyFunction(method).body().append(new EzyInstruction("\t", "\n", false).append("try {")).append(new EzyInstruction("\t\t", "\n").append("return this.supply$impl(arg0)")).append(new EzyInstruction("\t", "\n", false).append("} catch(").clazz(Exception.class).append(" e) {")).append(new EzyInstruction("\t\t", "\n\t}\n").append("throw new ").clazz(IllegalStateException.class).bracketopen().string("can't create bean of " + this.clazz.getClazz().getTypeName()).append(", e").bracketclose()).function().toString();
    }

    private String makeSupplyImplMethodContent(EzyMethod method) {
        EzyFunction.EzyBody methodBody = new EzyFunction(method).modifier("protected").body();
        this.addConstructInstruction(methodBody);
        this.addSetPropertiesInstructions(methodBody);
        this.addBindingValueInstructions(methodBody);
        this.addCallPostInitInstructions(methodBody);
        this.addReturnInstruction(methodBody);
        EzyFunction function = methodBody.function();
        return function.toString();
    }

    private void addConstructInstruction(EzyFunction.EzyBody body) {
        List<String> cparams = this.addAndGetConstructorParamNames(body);
        EzyInstruction instruction = this.newConstructInstruction(body, cparams);
        body.append(instruction);
    }

    private List<String> addAndGetConstructorParamNames(EzyFunction.EzyBody body) {
        int index = 0;
        ArrayList<String> cparams = new ArrayList<String>();
        String[] argumentNames = this.getConstructorArgumentNames();
        for (Class<?> type : this.getConstructorParameterTypes()) {
            String variableName = "cparam" + index;
            String beanName = EzyStrings.getString((String[])argumentNames, (int)index++, (String)variableName);
            cparams.add(variableName);
            body.append(this.newVariableInstruction(type, variableName, beanName));
        }
        return cparams;
    }

    protected EzyInstruction newConstructInstruction(EzyFunction.EzyBody body, List<String> cparams) {
        return new EzyInstruction("\t", "\n").variable(this.clazz.getClazz(), "object").equal().append("new ").clazz(this.clazz.getClazz()).bracketopen().append(EzyStrings.join(cparams, (String)", ")).bracketclose();
    }

    protected final EzyInstruction newVariableInstruction(Class varType, String varName, String beanName) {
        return new EzyInstruction("\t", "\n").variable(varType, varName).equal().bracketopen().clazz(varType).bracketclose().append("arg0.getBean").bracketopen().string(beanName).comma().clazz(varType, true).bracketclose();
    }

    private void addReturnInstruction(EzyFunction.EzyBody body) {
        EzyInstruction instruction = new EzyInstruction("\t", "\n").answer().append("object");
        body.append(instruction);
    }

    private void addSetPropertiesInstructions(EzyFunction.EzyBody body) {
        for (EzyField field : this.propertyFields) {
            this.addSetPropertyInstruction(body, field);
        }
        for (EzySetterMethod method : this.propertyMethods) {
            this.addSetPropertyInstruction(body, method);
        }
    }

    private void addSetPropertyInstruction(EzyFunction.EzyBody body, EzyField field) {
        Class propertyType = field.getType();
        String propertyName = this.getPropertyName((EzyReflectElement)field);
        String propertyVariableName = field.getName() + "PropertyValue";
        body.append(this.newGetPropertyInstruction(propertyVariableName, propertyType, propertyName));
        body.append(new EzyInstruction("\t", "\n", false).append("if(" + propertyVariableName + " != null)"));
        EzyInstruction instruction = new EzyInstruction("\t\t", "\n").append("object.").append(field.getName()).equal().cast(propertyType, propertyVariableName);
        body.append(instruction);
    }

    private void addSetPropertyInstruction(EzyFunction.EzyBody body, EzySetterMethod method) {
        Class propertyType = method.getType();
        String propertyName = this.getPropertyName((EzyReflectElement)method);
        String propertyVariableName = method.getFieldName() + "PropertyValue";
        body.append(this.newGetPropertyInstruction(propertyVariableName, propertyType, propertyName));
        body.append(new EzyInstruction("\t", "\n", false).append("if(" + propertyVariableName + " != null)"));
        EzyInstruction instruction = new EzyInstruction("\t\t", "\n").append("object.").append(method.getName()).bracketopen().cast(propertyType, propertyVariableName).bracketclose();
        body.append(instruction);
    }

    private EzyInstruction newGetPropertyInstruction(String propertyVariableName, Class<?> propertyType, String propertyName) {
        return new EzyInstruction("\t", "\n").variable(Object.class, propertyVariableName).equal().append("arg0.getProperty").bracketopen().string(propertyName).comma().clazz(propertyType, true).bracketclose();
    }

    private void addBindingValueInstructions(EzyFunction.EzyBody body) {
        for (EzyField field : this.bindingFields) {
            this.addBindingValueInstruction(body, field);
        }
        for (EzySetterMethod method : this.bindingMethods) {
            this.addBindingValueInstruction(body, method);
        }
    }

    private void addBindingValueInstruction(EzyFunction.EzyBody body, EzyField field) {
        String variableName = field.getName() + this.variableCount.incrementAndGet();
        Class propertyType = field.getType();
        body.append(this.newVariableInstruction(propertyType, variableName, this.getBeanName((EzyReflectElement)field)));
        EzyInstruction instruction = new EzyInstruction("\t", "\n").append("object.").append(field.getName()).equal().append(variableName);
        body.append(instruction);
    }

    private void addBindingValueInstruction(EzyFunction.EzyBody body, EzySetterMethod method) {
        String variableName = method.getFieldName() + this.variableCount.incrementAndGet();
        Class propertyType = method.getType();
        body.append(this.newVariableInstruction(propertyType, variableName, this.getBeanName((EzyReflectElement)method)));
        EzyInstruction instruction = new EzyInstruction("\t", "\n").append("object.").append(method.getName()).brackets(variableName);
        body.append(instruction);
    }

    private void addCallPostInitInstructions(EzyFunction.EzyBody body) {
        List<EzyMethod> methods = this.getPostInitMethods();
        methods.forEach(m -> this.addCallPostInitInstruction(body, (EzyMethod)m));
    }

    private void addCallPostInitInstruction(EzyFunction.EzyBody body, EzyMethod method) {
        EzyInstruction instruction = new EzyInstruction("\t", "\n").append("object.").append(method.getName()).brackets("");
        body.append(instruction);
    }

    private String getImplClassName() {
        return this.clazz.getName() + "$EzyPrototypeSupplier$EzyAutoImpl$" + COUNT.incrementAndGet();
    }

    private EzyMethod getSupplyMethod() {
        return EzyMethod.builder().clazz(EzyPrototypeSupplier.class).methodName("supply").parameterTypes(new Class[]{EzyBeanContext.class}).build();
    }

    private EzyMethod getGetObjectTypeMethod() {
        return EzyMethod.builder().clazz(EzyPrototypeSupplier.class).methodName("getObjectType").build();
    }

    @Override
    protected boolean addMissingSetterFields() {
        return false;
    }

    private void printMethodContent(String methodContent) {
        if (debug) {
            this.logger.debug("reader: method content \n{}", (Object)methodContent);
        }
    }

    @Generated
    public static void setDebug(boolean debug) {
        EzySimplePrototypeSupplierLoader.debug = debug;
    }
}

