/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.validator;

import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyhttp.core.exception.HttpBadRequestException;
import java.util.Collection;
import java.util.Collections;
import org.youngmonkeys.ezyplatform.validator.DefaultValidator;

public class CommonValidator {
    public void validatePageSize(int pageSize) {
        if (!DefaultValidator.isValidWebPageSize((int)pageSize)) {
            throw new HttpBadRequestException(Collections.singletonMap("pageSize", "invalid"));
        }
    }

    public void validateCollectionSize(String resourceName, Collection<?> collection) {
        if (!DefaultValidator.isValidCollectionSize(collection)) {
            throw new HttpBadRequestException(Collections.singletonMap(resourceName, "invalid"));
        }
    }

    public void validateSearchText(String textName, String textValue) {
        this.validateSearchText(textName, textValue, 128);
    }

    public void validateSearchText(String textName, String textValue, int maxLength) {
        if (EzyStrings.isNotEmpty((CharSequence)textValue) && textValue.length() > maxLength) {
            throw new HttpBadRequestException(Collections.singletonMap(textName, "invalid"));
        }
    }

    public void validateSearchUuid(String uuid) {
        if (EzyStrings.isNotEmpty((CharSequence)uuid) && !DefaultValidator.isValidUuid((String)uuid)) {
            throw new HttpBadRequestException(Collections.singletonMap("uuid", "invalid"));
        }
    }

    public void validateSearchKeyword(String keyword) {
        if (EzyStrings.isNotEmpty((CharSequence)keyword) && !this.isValidSearchKeyword(keyword)) {
            throw new HttpBadRequestException(Collections.singletonMap("keyword", "invalid"));
        }
    }

    public boolean isValidSearchKeyword(String keyword) {
        return keyword.codePoints().count() <= 120L && !DefaultValidator.maybeContainsSqlInjection((String)keyword) && keyword.split(" ").length <= 30;
    }
}

