/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.gamebox.manager;

import com.tvd12.gamebox.entity.LocatedPlayer;
import com.tvd12.gamebox.exception.LocationNotAvailableException;
import com.tvd12.gamebox.exception.PlayerExistsException;
import com.tvd12.gamebox.manager.LocatedPlayerManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;

public class DefaultLocatedPlayerManager
implements LocatedPlayerManager {
    protected final Map<String, LocatedPlayer> playerByName = this.newPlayerByNameMap();
    protected final NavigableMap<Integer, LocatedPlayer> playerByLocation = this.newPlayerByLocationsMap();
    protected LocatedPlayer master;
    protected LocatedPlayer speakinger;

    @Override
    public LocatedPlayer getPlayer(int location) {
        return (LocatedPlayer)this.playerByLocation.get(location);
    }

    @Override
    public void addPlayer(LocatedPlayer player, int location) {
        LocatedPlayer current = (LocatedPlayer)this.playerByLocation.get(location);
        if (current != null) {
            throw new LocationNotAvailableException("location: " + location + " has owned by: " + current.getName());
        }
        if (this.playerByName.containsKey(player.getName())) {
            throw new PlayerExistsException(player.getName());
        }
        player.setLocation(location);
        this.playerByLocation.put(location, player);
        this.playerByName.put(player.getName(), player);
    }

    @Override
    public LocatedPlayer removePlayer(int location) {
        LocatedPlayer removed = (LocatedPlayer)this.playerByLocation.remove(location);
        if (removed != null) {
            this.playerByName.remove(removed.getName());
        }
        return removed;
    }

    @Override
    public LocatedPlayer setNewMaster() {
        this.master = this.nextOf(this.master);
        return this.master;
    }

    @Override
    public List<String> getPlayerNames() {
        return new ArrayList<String>(this.playerByName.keySet());
    }

    @Override
    public int getPlayerCount() {
        return this.playerByLocation.size();
    }

    @Override
    public boolean containsPlayer(String username) {
        return this.playerByName.containsKey(username);
    }

    @Override
    public boolean isEmpty() {
        return this.playerByLocation.isEmpty();
    }

    @Override
    public LocatedPlayer nextOf(LocatedPlayer player, Predicate<LocatedPlayer> condition) {
        if (player == null) {
            return null;
        }
        int currentLocation = player.getLocation();
        LocatedPlayer leftPlayer = this.find(currentLocation, condition, this.playerByLocation::lowerEntry);
        LocatedPlayer rightPlayer = this.find(currentLocation, condition, this.playerByLocation::higherEntry);
        return this.getCloserPlayer(leftPlayer, rightPlayer, currentLocation);
    }

    private LocatedPlayer find(int currentLocation, Predicate<LocatedPlayer> condition, Function<Integer, Map.Entry<Integer, LocatedPlayer>> function) {
        Map.Entry<Integer, LocatedPlayer> next = function.apply(currentLocation);
        while (next != null && !condition.test(next.getValue())) {
            next = function.apply(next.getKey());
        }
        return next != null ? next.getValue() : null;
    }

    private LocatedPlayer getCloserPlayer(LocatedPlayer left, LocatedPlayer right, int location) {
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return location - left.getLocation() < right.getLocation() - location ? left : right;
    }

    @Override
    public LocatedPlayer rightOf(LocatedPlayer player, Predicate<LocatedPlayer> condition) {
        return this.findCircle(player.getLocation(), condition, this.playerByLocation::higherEntry, this.playerByLocation::firstEntry);
    }

    @Override
    public LocatedPlayer leftOf(LocatedPlayer player, Predicate<LocatedPlayer> condition) {
        return this.findCircle(player.getLocation(), condition, this.playerByLocation::lowerEntry, this.playerByLocation::lastEntry);
    }

    private LocatedPlayer findCircle(int currentLocation, Predicate<LocatedPlayer> condition, Function<Integer, Map.Entry<Integer, LocatedPlayer>> jumpFunction, Supplier<Map.Entry<Integer, LocatedPlayer>> anchorSupplier) {
        Map.Entry<Integer, LocatedPlayer> next;
        int nextLocation = currentLocation;
        while (true) {
            if ((next = jumpFunction.apply(nextLocation)) == null) {
                next = anchorSupplier.get();
            }
            if (next == null || next.getKey() == currentLocation) {
                return null;
            }
            if (condition.test(next.getValue())) break;
            nextLocation = next.getKey();
        }
        return next.getValue();
    }

    protected Map<String, LocatedPlayer> newPlayerByNameMap() {
        return new HashMap<String, LocatedPlayer>();
    }

    protected NavigableMap<Integer, LocatedPlayer> newPlayerByLocationsMap() {
        return new TreeMap<Integer, LocatedPlayer>();
    }

    public String toString() {
        return "(master: " + this.master + ", speakinger: " + this.speakinger + ", playerByLocation: " + this.playerByLocation + ")";
    }

    @Override
    @Generated
    public LocatedPlayer getMaster() {
        return this.master;
    }

    @Override
    @Generated
    public void setMaster(LocatedPlayer master) {
        this.master = master;
    }

    @Override
    @Generated
    public LocatedPlayer getSpeakinger() {
        return this.speakinger;
    }

    @Override
    @Generated
    public void setSpeakinger(LocatedPlayer speakinger) {
        this.speakinger = speakinger;
    }
}

