/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.core.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.tvd12.ezyhttp.core.codec.SingletonStringDeserializer;
import com.tvd12.reflections.util.Lists;
import java.io.IOException;
import java.util.List;

public class ListStringDeserializer
extends StdDeserializer<List<String>> {
    private static final long serialVersionUID = -4497810070359275209L;

    public ListStringDeserializer() {
        super(List.class);
    }

    public List<String> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.currentTokenId() == JsonToken.VALUE_STRING.id()) {
            return SingletonStringDeserializer.getInstance().deserialize(p.getValueAsString(), List.class, String.class);
        }
        return Lists.newArrayList((Object[])((Object[])ctxt.readValue(p, String[].class)));
    }
}

