/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.properties.file.struct;

import com.tvd12.properties.file.annotation.PropertyAnnotations;
import com.tvd12.properties.file.io.DefaultValueConverter;
import com.tvd12.properties.file.io.ValueConverter;
import com.tvd12.properties.file.mapping.MappingLevel;
import com.tvd12.properties.file.mapping.PropertiesMapper;
import com.tvd12.properties.file.struct.ClassWrapper;
import com.tvd12.properties.file.struct.MethodStruct;
import com.tvd12.properties.file.util.Logger;
import com.tvd12.properties.file.util.PropertiesUtil;
import com.tvd12.properties.file.util.ReflectionClassUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Properties;

public class PropertiesBean {
    private final Object bean;
    private final ClassWrapper wrapper;
    private final ClassLoader classLoader;
    private final ValueConverter valueConverter;
    private final PropertyAnnotations propertyAnnotations;

    public PropertiesBean(Class<?> clazz) {
        this(clazz, new PropertyAnnotations());
    }

    public PropertiesBean(Class<?> clazz, PropertyAnnotations propertyAnnotations) {
        this(ReflectionClassUtil.newInstance(clazz), propertyAnnotations);
    }

    public PropertiesBean(Object bean, PropertyAnnotations propertyAnnotations) {
        this(bean, MappingLevel.ALL, DefaultValueConverter.getInstance(), propertyAnnotations, null);
    }

    public PropertiesBean(Object bean, MappingLevel mappingLevel, ValueConverter valueConverter, PropertyAnnotations propertyAnnotations, ClassLoader classLoader) {
        this.bean = bean;
        this.classLoader = classLoader;
        this.propertyAnnotations = propertyAnnotations;
        this.wrapper = new ClassWrapper(bean.getClass(), mappingLevel, propertyAnnotations);
        this.valueConverter = valueConverter != null ? valueConverter : DefaultValueConverter.getInstance();
    }

    public PropertiesBean(Class<?> clazz, Properties properties, MappingLevel mappingLevel, ValueConverter valueConverter, PropertyAnnotations propertyAnnotations, ClassLoader classLoader) {
        this.wrapper = new ClassWrapper(clazz, mappingLevel, propertyAnnotations);
        this.valueConverter = valueConverter != null ? valueConverter : DefaultValueConverter.getInstance();
        this.classLoader = classLoader;
        this.propertyAnnotations = propertyAnnotations;
        this.bean = this.createBean(properties);
    }

    public <T> T getObject() {
        return (T)this.bean;
    }

    protected MethodStruct getWriteMethodStruct(Object key) {
        return this.wrapper.getMethodStruct(key.toString());
    }

    public void put(Object key, Object value) {
        this.put(key, value, null);
    }

    public void put(Object key, Object value, Properties properties) {
        MethodStruct methodStruct = this.getWriteMethodStruct(key);
        if (methodStruct == null) {
            return;
        }
        try {
            Object argument = this.transform(methodStruct, value, properties);
            if (argument == null) {
                return;
            }
            if (methodStruct.getMethod() != null) {
                methodStruct.getMethod().invoke(this.bean, argument);
            } else {
                Field field = methodStruct.getField();
                if (Modifier.isFinal(field.getModifiers())) {
                    return;
                }
                if (!Modifier.isPublic(field.getModifiers())) {
                    field.setAccessible(true);
                }
                field.set(this.bean, argument);
            }
        }
        catch (Exception e) {
            this.printError("put value: " + value + " with key: " + key + " error", e);
        }
    }

    public void putAll(Properties properties) {
        for (String key : this.wrapper.keySet()) {
            Object value = PropertiesUtil.getValue(properties, key);
            this.put(key, value, properties);
        }
    }

    private Class getWriteArgumentType(MethodStruct methodStruct) {
        if (methodStruct.getField() != null) {
            return methodStruct.getField().getType();
        }
        return methodStruct.getMethod().getParameterTypes()[0];
    }

    private Object transform(MethodStruct methodStruct, Object value, Properties properties) {
        boolean guessPrefix = properties != null && value == null;
        String prefix = methodStruct.getPropertyPrefix(guessPrefix);
        Class argumentType = this.getWriteArgumentType(methodStruct);
        if (properties == null || prefix.isEmpty()) {
            if (value == null) {
                return null;
            }
            Object v = value;
            if (v instanceof String) {
                v = ((String)value).trim();
            }
            return this.transform(v, argumentType);
        }
        return this.transformValue(properties, prefix, argumentType, methodStruct.getGenericType());
    }

    private Object transform(Object value, Class newType) {
        return this.valueConverter.convert(value, newType);
    }

    private Object createBean(Properties properties) {
        Constructor constructor = this.wrapper.getNoArgsDeclaredConstructor();
        if (constructor != null) {
            return this.wrapper.newObjectInstance();
        }
        return this.createBeanByMaxArgsConstructor(properties);
    }

    private Object createBeanByMaxArgsConstructor(Properties properties) {
        Constructor<?> constructor = this.wrapper.getMaxArgsDeclaredConstructor();
        Parameter[] parameters = constructor.getParameters();
        List declaredFieldStructs = this.wrapper.declaredFieldStructs;
        Object[] args = new Object[constructor.getParameterCount()];
        for (int i = 0; i < args.length; ++i) {
            Class<?> parameterType = parameters[i].getType();
            if (i >= declaredFieldStructs.size()) {
                args[i] = PropertiesUtil.defaultValueOf(parameterType);
                continue;
            }
            MethodStruct fieldStruct = (MethodStruct)declaredFieldStructs.get(i);
            Class<?> fieldType = fieldStruct.getType();
            String key = fieldStruct.getKey();
            args[i] = this.getAndTransform(properties, key, parameterType);
            if (args[i] != null) continue;
            args[i] = this.transformValue(properties, fieldStruct.guestPropertyPrefix(), fieldType, fieldStruct.getGenericType());
        }
        return ReflectionClassUtil.newInstance(constructor, args);
    }

    private Object transformValue(Properties properties, String prefix, Class<?> valueType, Type genericType) {
        try {
            if (PropertiesUtil.containsPrefix(properties, prefix)) {
                return new PropertiesMapper().data(properties).classLoader(this.classLoader).propertyPrefix(prefix).valueConverter(this.valueConverter).propertyAnnotations(this.propertyAnnotations).map(valueType, genericType);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object getAndTransform(Properties properties, String key, Class newType) {
        Object value = PropertiesUtil.getValue(properties, key);
        if (value != null) {
            return this.transform(value, newType);
        }
        return PropertiesUtil.defaultValueOf(newType);
    }

    protected void printError(String message, Throwable throwable) {
        Logger.print(message, throwable);
    }
}

