/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.config;

import com.tvd12.ezyfox.bean.EzyBeanConfig;
import com.tvd12.ezyfox.bean.annotation.EzyAutoBind;
import com.tvd12.ezyfox.bean.annotation.EzyConfigurationBefore;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.jdbc.AdminJdbcProxy;
import org.youngmonkeys.ezyplatform.admin.manager.AdminFileSystemManager;

@EzyConfigurationBefore(priority=-2147483648)
public class AdminScriptsRunner
extends EzyLoggable
implements EzyBeanConfig {
    @EzyAutoBind
    private AdminJdbcProxy jdbcProxy;
    @EzyAutoBind
    private AdminFileSystemManager fileSystemManager;
    private final List<String> runScriptFiles = new ArrayList<String>();

    public void config() {
        try {
            this.doConfig();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void doConfig() throws Exception {
        try (Connection connection = this.jdbcProxy.createConnection();){
            for (File scriptFile : this.fileSystemManager.getAdminScriptFiles()) {
                String fileName = scriptFile.getName();
                if (this.hasRunScriptFile(connection, fileName) || !this.jdbcProxy.runScriptFile(connection, scriptFile.toString())) continue;
                this.runScriptFiles.add(fileName);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasRunScriptFile(Connection connection, String fileName) {
        try (PreparedStatement statement = connection.prepareStatement("SELECT count(*) FROM ezy_run_script_histories WHERE module_name = 'ezyplatform' AND module_type = 'PLATFORM' AND script_name = ?");){
            statement.setString(1, fileName);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                int count = resultSet.getInt(1);
                boolean bl2 = count > 0;
                return bl2;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.logger.info("check has run script file failed, return false by default, exception is: {} ({})", (Object)e.getClass().getName(), (Object)e.getMessage());
            return false;
        }
    }

    @Generated
    public void setJdbcProxy(AdminJdbcProxy jdbcProxy) {
        this.jdbcProxy = jdbcProxy;
    }

    @Generated
    public void setFileSystemManager(AdminFileSystemManager fileSystemManager) {
        this.fileSystemManager = fileSystemManager;
    }

    @Generated
    public List<String> getRunScriptFiles() {
        return this.runScriptFiles;
    }
}

