/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.monitor;

import com.sun.management.GarbageCollectorMXBean;
import com.sun.management.GcInfo;
import java.lang.management.ManagementFactory;
import java.util.List;

public class EzyGcMonitor {
    protected volatile long lastGcActivityTime = System.nanoTime();
    protected static final double MILLIS_TO_NANO = 1000000.0;

    public double getProcessGcActivity() {
        int totalGC = 0;
        long totalGCTime = 0L;
        List<?> beans = this.getGarbageCollectorMXBeans();
        for (Object bean : beans) {
            GarbageCollectorMXBean gc;
            GcInfo info;
            if (!(bean instanceof GarbageCollectorMXBean) || (info = (gc = (GarbageCollectorMXBean)bean).getLastGcInfo()) == null) continue;
            ++totalGC;
            totalGCTime += info.getDuration();
        }
        if (totalGCTime <= 0L) {
            return 0.0;
        }
        long currentTime = System.nanoTime();
        long offsetTime = currentTime - this.lastGcActivityTime;
        this.lastGcActivityTime = currentTime;
        return (double)totalGCTime * 1000000.0 / (double)(offsetTime * (long)totalGC);
    }

    protected List<?> getGarbageCollectorMXBeans() {
        return ManagementFactory.getGarbageCollectorMXBeans();
    }
}

