/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.request;

import com.tvd12.ezyhttp.core.constant.HttpMethod;
import com.tvd12.ezyhttp.server.core.request.RequestURIMeta;
import lombok.Generated;

public class RequestURI {
    protected final String uri;
    protected final HttpMethod method;
    protected final boolean api;
    protected final boolean authenticated;
    protected final boolean authenticatable;
    protected final boolean management;
    protected final boolean resource;
    protected final boolean payment;
    protected final String feature;
    protected final String resourceFullPath;

    public RequestURI(HttpMethod method, String uri, boolean management) {
        this.method = method;
        this.uri = this.standardizeURI(uri);
        this.management = management;
        this.api = false;
        this.authenticated = false;
        this.authenticatable = false;
        this.resource = false;
        this.payment = false;
        this.feature = null;
        this.resourceFullPath = null;
    }

    public RequestURI(HttpMethod method, String uri, boolean management, boolean resource, boolean api, String resourceFullPath) {
        this(method, uri, RequestURIMeta.builder().api(api).authenticated(false).authenticatable(false).management(management).resource(resource).resourceFullPath(resourceFullPath).build());
    }

    public RequestURI(HttpMethod method, String uri, RequestURIMeta meta) {
        this.method = method;
        this.uri = this.standardizeURI(uri);
        this.api = meta.isApi();
        this.authenticated = meta.isAuthenticated();
        this.authenticatable = meta.isAuthenticatable();
        this.management = meta.isManagement();
        this.resource = meta.isResource();
        this.payment = meta.isPayment();
        this.feature = meta.getFeature();
        this.resourceFullPath = meta.getResourceFullPath();
    }

    protected String standardizeURI(String uri) {
        if (uri.isEmpty() || uri.startsWith("/")) {
            return uri;
        }
        return "/" + uri;
    }

    public String getSameURI() {
        return RequestURI.getSameURI(this.uri);
    }

    public static String getSameURI(String originalURI) {
        if (originalURI.length() <= 1) {
            return originalURI;
        }
        if (originalURI.endsWith("/")) {
            return originalURI.substring(0, originalURI.length() - 1);
        }
        return originalURI + "/";
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        RequestURI t = (RequestURI)other;
        return this.uri.equals(t.uri) && this.method.equals((Object)t.method) && this.management == t.management;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = result * prime + this.uri.hashCode();
        result = result * prime + this.method.hashCode();
        result = result * prime + Boolean.hashCode(this.management);
        return result;
    }

    public String toString() {
        return this.uri + " - " + this.method;
    }

    @Generated
    public String getUri() {
        return this.uri;
    }

    @Generated
    public HttpMethod getMethod() {
        return this.method;
    }

    @Generated
    public boolean isApi() {
        return this.api;
    }

    @Generated
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Generated
    public boolean isAuthenticatable() {
        return this.authenticatable;
    }

    @Generated
    public boolean isManagement() {
        return this.management;
    }

    @Generated
    public boolean isResource() {
        return this.resource;
    }

    @Generated
    public boolean isPayment() {
        return this.payment;
    }

    @Generated
    public String getFeature() {
        return this.feature;
    }

    @Generated
    public String getResourceFullPath() {
        return this.resourceFullPath;
    }
}

