/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.view;

import com.tvd12.ezyfox.bean.EzyPropertyFetcher;
import com.tvd12.ezyfox.builder.EzyBuilder;
import lombok.Generated;

public class TemplateResolver {
    private final String prefix;
    private final String suffix;
    private final String characterEncoding;
    private final int cacheTTLMs;
    private final boolean cacheable;
    private final String templateMode;
    private final String messagesLocation;

    protected TemplateResolver(Builder builder) {
        this.prefix = builder.prefix;
        this.suffix = builder.suffix;
        this.characterEncoding = builder.characterEncoding;
        this.cacheTTLMs = builder.cacheTTLMs;
        this.cacheable = builder.cacheable;
        this.templateMode = builder.templateMode;
        this.messagesLocation = builder.messagesLocation;
    }

    public static TemplateResolver of(EzyPropertyFetcher propertyFetcher) {
        return TemplateResolver.builder().setFrom(propertyFetcher).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Generated
    public String getSuffix() {
        return this.suffix;
    }

    @Generated
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    @Generated
    public int getCacheTTLMs() {
        return this.cacheTTLMs;
    }

    @Generated
    public boolean isCacheable() {
        return this.cacheable;
    }

    @Generated
    public String getTemplateMode() {
        return this.templateMode;
    }

    @Generated
    public String getMessagesLocation() {
        return this.messagesLocation;
    }

    public static class Builder
    implements EzyBuilder<TemplateResolver> {
        private String prefix = "templates/";
        private String suffix = ".html";
        private String characterEncoding = "UTF-8";
        private int cacheTTLMs = 3600000;
        private boolean cacheable = true;
        private String templateMode = "HTML";
        private String messagesLocation = "messages";

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public Builder characterEncoding(String characterEncoding) {
            this.characterEncoding = characterEncoding;
            return this;
        }

        public Builder cacheTTLMs(int cacheTTLMs) {
            this.cacheTTLMs = cacheTTLMs;
            return this;
        }

        public Builder cacheable(boolean cacheable) {
            this.cacheable = cacheable;
            return this;
        }

        public Builder templateMode(String templateMode) {
            this.templateMode = templateMode;
            return this;
        }

        public Builder messagesLocation(String messagesLocation) {
            this.messagesLocation = messagesLocation;
            return this;
        }

        public Builder setFrom(EzyPropertyFetcher propertyFetcher) {
            this.templateMode = (String)propertyFetcher.getProperty((Object)"view.template.mode", String.class, (Object)this.templateMode);
            this.prefix = (String)propertyFetcher.getProperty((Object)"view.template.prefix", String.class, (Object)this.prefix);
            this.suffix = (String)propertyFetcher.getProperty((Object)"view.template.suffix", String.class, (Object)this.suffix);
            this.characterEncoding = (String)propertyFetcher.getProperty((Object)"view.template.character_encoding", String.class, (Object)this.characterEncoding);
            this.cacheTTLMs = (Integer)propertyFetcher.getProperty((Object)"view.template.cache_ttl_ms", Integer.TYPE, (Object)this.cacheTTLMs);
            this.cacheable = (Boolean)propertyFetcher.getProperty((Object)"view.template.cacheable", Boolean.TYPE, (Object)this.cacheable);
            this.messagesLocation = (String)propertyFetcher.getProperty((Object)"view.template.messages_location", String.class, (Object)this.messagesLocation);
            return this;
        }

        public TemplateResolver build() {
            return new TemplateResolver(this);
        }
    }
}

