/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.codec;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.codec.EzyCodecCreator;
import com.tvd12.ezyfox.codec.EzyMessageByTypeSerializer;
import com.tvd12.ezyfox.codec.EzyMessageDeserializer;
import com.tvd12.ezyfox.codec.JacksonByteToMessageDecoder;
import com.tvd12.ezyfox.codec.JacksonMessageToByteEncoder;
import com.tvd12.ezyfox.codec.JacksonSimpleDeserializer;
import com.tvd12.ezyfox.codec.JacksonSimpleSerializer;
import com.tvd12.ezyfox.jackson.JacksonObjectMapperBuilder;

public class JacksonCodecCreator
implements EzyCodecCreator {
    protected final ObjectMapper objectMapper = this.newObjectMapper();
    protected final EzyMessageDeserializer deserializer;
    protected final EzyMessageByTypeSerializer serializer = this.newSerializer();

    public JacksonCodecCreator() {
        this.deserializer = this.newDeserializer();
    }

    protected ObjectMapper newObjectMapper() {
        return JacksonObjectMapperBuilder.newInstance().build();
    }

    protected EzyMessageDeserializer newDeserializer() {
        return new JacksonSimpleDeserializer(this.objectMapper);
    }

    protected EzyMessageByTypeSerializer newSerializer() {
        return new JacksonSimpleSerializer(this.objectMapper);
    }

    public Object newEncoder() {
        return new JacksonMessageToByteEncoder(this.serializer);
    }

    public Object newDecoder(int maxRequestSize) {
        return new JacksonByteToMessageDecoder(this.deserializer);
    }
}

