/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.appender;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.io.EzyLists;
import java.time.LocalDateTime;
import java.util.List;
import org.youngmonkeys.ezyplatform.admin.appender.AdminLinkAppender;
import org.youngmonkeys.ezyplatform.admin.repo.AdminLinkRepository;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.constant.CommonConstants;
import org.youngmonkeys.ezyplatform.pagination.LastUpdatedAtPageToken;
import org.youngmonkeys.ezyplatform.time.ClockProxy;

public abstract class AdminLastUpdatedAtLinkAppender<T>
extends AdminLinkAppender<T, LastUpdatedAtPageToken> {
    public AdminLastUpdatedAtLinkAppender(ClockProxy clock, ObjectMapper objectMapper, AdminSettingService settingService, AdminLinkRepository linkRepository) {
        super(clock, objectMapper, settingService, linkRepository);
    }

    @Override
    protected LastUpdatedAtPageToken extractNewLastPageToken(List<T> valueList, LastUpdatedAtPageToken currentLastPageToken) {
        return currentLastPageToken.newLastPageToken(valueList.size(), () -> this.extractLastUpdatedAt(EzyLists.last((List)valueList)), () -> this.extractLastId(EzyLists.last((List)valueList)));
    }

    protected abstract LocalDateTime extractLastUpdatedAt(T var1);

    protected Object extractLastId(T value) {
        return null;
    }

    @Override
    protected LastUpdatedAtPageToken defaultPageToken() {
        return LastUpdatedAtPageToken.defaultPageToken((LocalDateTime)this.firstUpdatedAt());
    }

    protected LocalDateTime firstUpdatedAt() {
        return CommonConstants.MIN_SQL_DATETIME;
    }

    @Override
    protected Class<LastUpdatedAtPageToken> pageTokenType() {
        return LastUpdatedAtPageToken.class;
    }
}

