/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.decorator;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.youngmonkeys.ezyplatform.model.AdminAccessTokenModel;

public final class AdminLoginResponseDecorators {
    private AdminLoginResponseDecorators() {
    }

    public static void decorateToAddAdminAccessToken(HttpServletResponse response, AdminAccessTokenModel accessToken) {
        response.addCookie(AdminLoginResponseDecorators.newAccessTokenCookie(accessToken));
        response.addCookie(AdminLoginResponseDecorators.newAccessTokenExpiredAtCookie(accessToken));
    }

    public static Cookie newAccessTokenCookie(AdminAccessTokenModel accessToken) {
        Cookie accessTokenCookie = new Cookie("adminAccessToken", accessToken.getAccessToken());
        accessTokenCookie.setPath("/");
        accessTokenCookie.setMaxAge(accessToken.getMaxAge());
        return accessTokenCookie;
    }

    public static Cookie newAccessTokenExpiredAtCookie(AdminAccessTokenModel accessToken) {
        Cookie accessTokenExpiredAtCookie = new Cookie("adminAccessTokenExpiredAt", String.valueOf(accessToken.getExpiredAtTimestamp()));
        accessTokenExpiredAtCookie.setPath("/");
        accessTokenExpiredAtCookie.setMaxAge(accessToken.getMaxAge());
        return accessTokenExpiredAtCookie;
    }
}

