/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.decorator;

import com.tvd12.ezyhttp.server.core.annotation.Service;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.converter.AdminModelToResponseConverter;
import org.youngmonkeys.ezyplatform.admin.response.AdminNotificationResponse;
import org.youngmonkeys.ezyplatform.admin.service.AdminNotificationService;
import org.youngmonkeys.ezyplatform.model.NotificationReceiverModel;
import org.youngmonkeys.ezyplatform.model.PaginationModel;
import org.youngmonkeys.ezyplatform.model.SimpleNotificationModel;

@Service
public class AdminNotificationModelDecorator {
    private final AdminNotificationService notificationService;
    private final AdminModelToResponseConverter modelToResponseConverter;

    public PaginationModel<AdminNotificationResponse> decorate(PaginationModel<NotificationReceiverModel> pagination) {
        Set notificationIds = pagination.getItems().stream().map(NotificationReceiverModel::getNotificationId).filter(it -> it > 0L).collect(Collectors.toSet());
        Map notificationById = this.notificationService.getNotificationMapByIds(notificationIds);
        return pagination.map(it -> this.modelToResponseConverter.toResponse(notificationById.getOrDefault(it.getNotificationId(), SimpleNotificationModel.builder().build()), (NotificationReceiverModel)it));
    }

    @Generated
    public AdminNotificationModelDecorator(AdminNotificationService notificationService, AdminModelToResponseConverter modelToResponseConverter) {
        this.notificationService = notificationService;
        this.modelToResponseConverter = modelToResponseConverter;
    }
}

