/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.view;

import com.tvd12.ezyfox.annotation.EzyFeature;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.view.View;
import java.util.Properties;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.io.AdminPropertiesFileReader;
import org.youngmonkeys.ezyplatform.admin.io.AdminVmOptionsInteractor;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.admin.view.AdminDashboardType;
import org.youngmonkeys.ezyplatform.admin.view.AdminViewFactory;
import org.youngmonkeys.ezyplatform.entity.TargetType;

@Authenticated
@Controller
@EzyFeature(value="devops")
public class AdminDashboardController {
    private final AdminViewFactory viewFactory;
    private final AdminPropertiesFileReader propertiesFileReader;
    private final AdminVmOptionsInteractor vmOptionsInteractor;
    private final AdminSettingService settingService;

    @DoGet(value="/dashboard/web")
    public View dashboardWebGet() {
        return this.viewFactory.newDashboardViewBuilder(AdminDashboardType.WEB).addVariable("webManagementUrl", (Object)this.settingService.getWebManagementUrl()).addVariable("webProperties", (Object)this.propertiesFileReader.readWebConfigContent()).addVariable("webVmOptions", (Object)this.vmOptionsInteractor.readVmOptionsFile(TargetType.WEB)).build();
    }

    @DoGet(value="/dashboard/socket")
    public View dashboardSocketGet() {
        Properties properties = this.propertiesFileReader.readSocketConfigProperties();
        return this.viewFactory.newDashboardViewBuilder(AdminDashboardType.SOCKET).addVariable("socketProperties", (Object)this.propertiesFileReader.readSocketConfigContent()).addVariable("enableWebsocketSsl", (Object)Boolean.parseBoolean(properties.getProperty("websocket.ssl.enable", Boolean.FALSE.toString()))).addVariable("allowSslToReloadAutomatically", (Object)this.settingService.getBooleanValue("socket_auto_reload_ssl_enable", true)).addVariable("socketVmOptions", (Object)this.vmOptionsInteractor.readVmOptionsFile(TargetType.SOCKET)).build();
    }

    @DoGet(value="/dashboard/admin")
    public View dashboardAdminGet() {
        return this.viewFactory.newDashboardViewBuilder(AdminDashboardType.ADMIN).addVariable("adminUrl", (Object)this.settingService.getAdminUrl()).addVariable("adminProperties", (Object)this.propertiesFileReader.readAdminConfigContent()).addVariable("adminVmOptions", (Object)this.vmOptionsInteractor.readVmOptionsFile(TargetType.ADMIN)).build();
    }

    @Generated
    public AdminDashboardController(AdminViewFactory viewFactory, AdminPropertiesFileReader propertiesFileReader, AdminVmOptionsInteractor vmOptionsInteractor, AdminSettingService settingService) {
        this.viewFactory = viewFactory;
        this.propertiesFileReader = propertiesFileReader;
        this.vmOptionsInteractor = vmOptionsInteractor;
        this.settingService = settingService;
    }
}

