/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.view;

import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.DoPost;
import com.tvd12.ezyhttp.server.core.annotation.RequestParam;
import com.tvd12.ezyhttp.server.core.request.RequestArguments;
import com.tvd12.ezyhttp.server.core.view.Redirect;
import com.tvd12.ezyhttp.server.core.view.View;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.controller.decorator.AdminLoginResponseDecorators;
import org.youngmonkeys.ezyplatform.admin.model.AddAdminModel;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminRoleService;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminService;
import org.youngmonkeys.ezyplatform.admin.validator.AdminSetupValidator;
import org.youngmonkeys.ezyplatform.model.AdminAccessTokenModel;

@Controller
public class AdminSetupController {
    private final AdminAdminService adminService;
    private final AdminAdminRoleService roleService;
    private final AdminSetupValidator setupValidator;

    @DoGet(value="/setup-admin")
    public Object setupAdminGet(RequestArguments arguments) {
        if (this.roleService.hasActiveSuperAdmin()) {
            return Redirect.to((String)"/");
        }
        return View.builder().template("setup/setup-admin").addVariable("errors", arguments.getRedirectionAttribute("errors", Collections.emptyMap())).build();
    }

    @DoPost(value="/setup-admin")
    public Redirect setupAdminPost(HttpServletResponse response, @RequestParam(name="username") String username, @RequestParam(name="email") String email, @RequestParam(name="password") String password) {
        if (this.roleService.hasActiveSuperAdmin()) {
            return Redirect.to((String)"/");
        }
        Set<Long> roleIds = Collections.singleton(this.roleService.getSuperAdminRoleId());
        Map<String, String> errors = this.setupValidator.validate(username, email, password);
        if (!errors.isEmpty()) {
            return Redirect.builder().uri("/setup-admin").addAttribute("errors", errors).build();
        }
        AddAdminModel adminModel = AddAdminModel.builder().username(username).email(email).password(password).roleIds(roleIds).build();
        AdminAccessTokenModel accessToken = this.adminService.addAdminAndGetAccessToken(adminModel);
        AdminLoginResponseDecorators.decorateToAddAdminAccessToken(response, accessToken);
        return Redirect.to((String)"/");
    }

    @Generated
    public AdminSetupController(AdminAdminService adminService, AdminAdminRoleService roleService, AdminSetupValidator setupValidator) {
        this.adminService = adminService;
        this.roleService = roleService;
        this.setupValidator = setupValidator;
    }
}

