/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.data;

import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.naming.EzyNamingCase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.data.MenuItem;

public class Menu {
    private final String name;
    private final String uri;
    private final String icon;
    private final String fullName;
    private final String moduleName;
    private final boolean visible;
    private final List<MenuItem> items;
    private final List<MenuItem> visibleItems;
    private final Map<String, MenuItem> itemByName;

    public Menu(String moduleName, String name, String uri, String icon, boolean visible) {
        this.name = name;
        this.uri = uri;
        this.icon = icon;
        this.moduleName = moduleName;
        this.visible = visible;
        this.itemByName = new ConcurrentHashMap<String, MenuItem>();
        this.items = Collections.synchronizedList(new ArrayList());
        this.visibleItems = Collections.synchronizedList(new ArrayList());
        this.fullName = EzyStrings.isEqualsIgnoreCase((String)moduleName, (String)name) ? name : EzyStrings.toUnderscoreCase((String)moduleName) + EzyNamingCase.DOT.getSign() + name;
    }

    public void addMenuItem(MenuItem menuItem) {
        this.itemByName.put(menuItem.getMenuFullName(), menuItem);
        this.items.add(menuItem);
        if (menuItem.isVisible()) {
            this.visibleItems.add(menuItem);
        }
    }

    public boolean hasItems() {
        return this.visibleItems.size() > 0;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getUri() {
        return this.uri;
    }

    @Generated
    public String getIcon() {
        return this.icon;
    }

    @Generated
    public String getFullName() {
        return this.fullName;
    }

    @Generated
    public String getModuleName() {
        return this.moduleName;
    }

    @Generated
    public boolean isVisible() {
        return this.visible;
    }

    @Generated
    public List<MenuItem> getItems() {
        return this.items;
    }

    @Generated
    public List<MenuItem> getVisibleItems() {
        return this.visibleItems;
    }
}

