/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.manager;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.collect.Sets;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.data.Target;
import org.youngmonkeys.ezyplatform.admin.io.AdminTargetInformationInteractor;
import org.youngmonkeys.ezyplatform.admin.manager.AdminFileSystemManager;
import org.youngmonkeys.ezyplatform.entity.TargetType;

@EzySingleton
public class AdminTargetManager
extends EzyLoggable {
    private final AdminFileSystemManager fileSystemManager;
    private final AdminTargetInformationInteractor targetInformationInteractor;
    private final Map<TargetType, Target> targets = new HashMap<TargetType, Target>();
    public static final Set<String> TARGET_FOLDERS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"admin", "socket", "web"}));

    public void saveTarget(Target target) {
        this.targetInformationInteractor.saveTarget(this.fileSystemManager.getRuntimeFolder(), target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Target getTarget(TargetType type) {
        if (this.targets.isEmpty()) {
            Map<TargetType, Target> map = this.targets;
            synchronized (map) {
                if (this.targets.isEmpty()) {
                    this.targets.putAll(this.readTargetMap());
                }
            }
        }
        return this.targets.get(type);
    }

    private Map<TargetType, Target> readTargetMap() {
        return this.targetInformationInteractor.readTargetMap(this.fileSystemManager.getRuntimeFolder());
    }

    @Generated
    public AdminTargetManager(AdminFileSystemManager fileSystemManager, AdminTargetInformationInteractor targetInformationInteractor) {
        this.fileSystemManager = fileSystemManager;
        this.targetInformationInteractor = targetInformationInteractor;
    }
}

