/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.pipeline;

import com.tvd12.ezyfox.bean.EzySingletonFactory;
import com.tvd12.ezyfox.io.EzyMaps;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.youngmonkeys.ezyplatform.admin.pipeline.AdminDataPipelineWorker;
import org.youngmonkeys.ezyplatform.concurrent.DefaultThreadFactory;

public class AdminDataPipeline
extends EzyLoggable {
    private final EzySingletonFactory singletonFactory;
    private final int maxSleepTime;
    private final AtomicBoolean stopped = new AtomicBoolean();
    private final List<AdminDataPipelineWorker> workers = new ArrayList<AdminDataPipelineWorker>();
    private final Map<String, AdminDataPipelineWorker> workerByName = new HashMap<String, AdminDataPipelineWorker>();
    private final Map<String, AtomicBoolean> needResetByWorkerName = new ConcurrentHashMap<String, AtomicBoolean>();
    private static final int MAX_SLEEP_TIME = 300;

    public AdminDataPipeline(EzySingletonFactory singletonFactory) {
        this(singletonFactory, 300);
    }

    public AdminDataPipeline(EzySingletonFactory singletonFactory, int maxSleepTime) {
        this.singletonFactory = singletonFactory;
        this.maxSleepTime = maxSleepTime;
    }

    public void start() {
        this.workers.addAll(this.singletonFactory.getSingletonsOf(AdminDataPipelineWorker.class));
        this.workers.sort(Comparator.comparingInt(AdminDataPipelineWorker::getPriority));
        this.workerByName.putAll(EzyMaps.newHashMap(this.workers, AdminDataPipelineWorker::getDisplayName));
        DefaultThreadFactory threadFactory = DefaultThreadFactory.create((String)"data-pipeline");
        Thread newThread = threadFactory.newThread(this::loop);
        newThread.start();
    }

    public void stop() {
        this.stopped.set(true);
    }

    public void reset(String workerName) {
        if (this.workerByName.containsKey(workerName)) {
            this.needResetByWorkerName.put(workerName, new AtomicBoolean(true));
        }
    }

    private void loop() {
        do {
            long elapsedTime;
            long remainSleepTime;
            long startTime = System.currentTimeMillis();
            for (AdminDataPipelineWorker worker : this.workers) {
                this.needResetByWorkerName.computeIfPresent(worker.getDisplayName(), (k, v) -> {
                    if (v.get()) {
                        v.set(false);
                        worker.reset();
                    }
                    return v;
                });
                try {
                    if (!worker.execute()) {
                        break;
                    }
                }
                catch (Exception e) {
                    this.logger.info("worker: {} error", (Object)worker, (Object)e);
                }
                if (!this.stopped.get()) continue;
                break;
            }
            if ((remainSleepTime = (long)this.maxSleepTime - (elapsedTime = System.currentTimeMillis() - startTime)) <= 0L) continue;
            try {
                Thread.sleep(remainSleepTime);
            }
            catch (InterruptedException e) {
                break;
            }
        } while (!this.stopped.get());
    }

    public List<AdminDataPipelineWorker> getWorkers() {
        return new ArrayList<AdminDataPipelineWorker>(this.workers);
    }
}

