/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.service;

import com.tvd12.ezyhttp.server.core.annotation.Service;
import com.tvd12.properties.file.reader.FileReader;
import java.util.Properties;
import java.util.function.Supplier;
import org.youngmonkeys.ezyplatform.admin.converter.AdminEntityToModelConverter;
import org.youngmonkeys.ezyplatform.admin.converter.AdminModelToEntityConverter;
import org.youngmonkeys.ezyplatform.admin.converter.AdminResultToModelConverter;
import org.youngmonkeys.ezyplatform.admin.model.AddContentTemplateModel;
import org.youngmonkeys.ezyplatform.admin.model.UpdateContentTemplateModel;
import org.youngmonkeys.ezyplatform.admin.repo.AdminContentTemplateRepository;
import org.youngmonkeys.ezyplatform.constant.CommonUserType;
import org.youngmonkeys.ezyplatform.converter.DefaultEntityToModelConverter;
import org.youngmonkeys.ezyplatform.converter.DefaultModelToEntityConverter;
import org.youngmonkeys.ezyplatform.converter.DefaultResultToModelConverter;
import org.youngmonkeys.ezyplatform.entity.ContentTemplate;
import org.youngmonkeys.ezyplatform.entity.ContentTemplateStatus;
import org.youngmonkeys.ezyplatform.repo.ContentTemplateRepository;
import org.youngmonkeys.ezyplatform.service.DefaultContentTemplateService;

@Service
public class AdminContentTemplateService
extends DefaultContentTemplateService {
    private final FileReader propertiesFileReader;
    private final AdminContentTemplateRepository contentTemplateRepository;
    private final AdminModelToEntityConverter modelToEntityConverter;

    public AdminContentTemplateService(FileReader propertiesFileReader, AdminContentTemplateRepository contentTemplateRepository, AdminEntityToModelConverter entityToModelConverter, AdminModelToEntityConverter modelToEntityConverter, AdminResultToModelConverter resultToModelConverter) {
        super((ContentTemplateRepository)contentTemplateRepository, (DefaultEntityToModelConverter)entityToModelConverter, (DefaultModelToEntityConverter)modelToEntityConverter, (DefaultResultToModelConverter)resultToModelConverter);
        this.propertiesFileReader = propertiesFileReader;
        this.contentTemplateRepository = contentTemplateRepository;
        this.modelToEntityConverter = modelToEntityConverter;
    }

    public long addTemplate(long adminId, String templateType, AddContentTemplateModel model) {
        return this.addTemplate(CommonUserType.ADMIN.toString(), adminId, templateType, model);
    }

    public long addTemplate(String creatorType, long creatorId, String templateType, AddContentTemplateModel model) {
        ContentTemplate entity = this.modelToEntityConverter.toEntity(creatorType, creatorId, templateType, model);
        this.contentTemplateRepository.save(entity);
        return entity.getId();
    }

    public long addTemplateIfAbsent(String templateType, String templateName, Supplier<AddContentTemplateModel> templateSupplier) {
        return this.addTemplateIfAbsent(0L, templateType, templateName, templateSupplier);
    }

    public long addTemplateIfAbsent(long adminId, String templateType, String templateName, Supplier<AddContentTemplateModel> templateSupplier) {
        return this.addTemplateIfAbsent(CommonUserType.ADMIN.toString(), adminId, templateType, templateName, templateSupplier);
    }

    public long addTemplateIfAbsent(String creatorType, long creatorId, String templateType, String templateName, Supplier<AddContentTemplateModel> templateSupplier) {
        ContentTemplate entity = this.contentTemplateRepository.findByTemplateTypeAndTemplateName(templateType, templateName);
        if (entity == null) {
            entity = this.modelToEntityConverter.toEntity(creatorType, creatorId, templateType, templateSupplier.get());
            this.contentTemplateRepository.save(entity);
        }
        return entity.getId();
    }

    public long addTemplateIfAbsentFromPropertiesFile(String templateType, String templateName, String propertiesFilePath) {
        return this.addTemplateIfAbsentFromPropertiesFile(0L, templateType, templateName, propertiesFilePath);
    }

    public long addTemplateIfAbsentFromPropertiesFile(long adminId, String templateType, String templateName, String propertiesFilePath) {
        Properties properties = this.propertiesFileReader.read(propertiesFilePath);
        return this.addTemplateIfAbsent(adminId, templateType, templateName, () -> AddContentTemplateModel.builder().templateName(templateName).titleTemplate(properties.getProperty("title")).contentTemplate(properties.getProperty("content")).status(ContentTemplateStatus.COMPLETED.toString()).build());
    }

    public void saveTemplate(UpdateContentTemplateModel model) {
        ContentTemplate entity = this.getContentTemplateEntityByIdOrThrow(model.getTemplateId());
        this.modelToEntityConverter.mergeToEntity(model, entity);
        this.contentTemplateRepository.save(entity);
    }
}

