/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.service;

import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.io.EzySets;
import com.tvd12.ezyhttp.server.core.annotation.Service;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.admin.converter.AdminModelToEntityConverter;
import org.youngmonkeys.ezyplatform.admin.repo.AdminRoleFeatureRepository;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.constant.CommonConstants;
import org.youngmonkeys.ezyplatform.entity.RoleFeature;
import org.youngmonkeys.ezyplatform.entity.RoleFeatureId;
import org.youngmonkeys.ezyplatform.entity.TargetType;
import org.youngmonkeys.ezyplatform.repo.RoleFeatureRepository;
import org.youngmonkeys.ezyplatform.service.DefaultRoleFeatureService;
import org.youngmonkeys.ezyplatform.service.SettingService;

@Service
public class AdminRoleFeatureService
extends DefaultRoleFeatureService {
    private final AdminSettingService settingService;
    private final AdminRoleFeatureRepository roleFeatureRepository;
    private final AdminModelToEntityConverter modelToEntityConverter;

    public AdminRoleFeatureService(AdminSettingService settingService, AdminRoleFeatureRepository roleFeatureRepository, AdminModelToEntityConverter modelToEntityConverter) {
        super(TargetType.ADMIN, (SettingService)settingService, (RoleFeatureRepository)roleFeatureRepository);
        this.settingService = settingService;
        this.roleFeatureRepository = roleFeatureRepository;
        this.modelToEntityConverter = modelToEntityConverter;
    }

    public void saveRoleFeatures(long roleId, TargetType targetType, Map<String, Map<String, List<String>>> methodsUriMapByFeature) {
        this.saveRoleFeatures(roleId, targetType.toString(), methodsUriMapByFeature);
    }

    public void saveRoleFeatures(long roleId, String targetType, Map<String, Map<String, List<String>>> methodsUriMapByFeature) {
        Map<RoleFeatureId, RoleFeature> incomingEntityMap = this.modelToEntityConverter.toRoleFeatureEntityMap(roleId, targetType, methodsUriMapByFeature);
        List all = this.roleFeatureRepository.findByRoleIdAndTarget(roleId, targetType);
        Set allIds = EzySets.newHashSet((Collection)all, RoleFeature::identifier);
        List removeIds = EzyLists.filter((Collection)allIds, it -> !incomingEntityMap.containsKey(it));
        List saveEntities = incomingEntityMap.entrySet().stream().filter(it -> !allIds.contains(it.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
        if (!removeIds.isEmpty()) {
            this.roleFeatureRepository.deleteByIds(removeIds);
        }
        this.roleFeatureRepository.save(saveEntities);
        this.settingService.setLastUpdateTime(CommonConstants.settingNameTargetRoleFeatures((String)targetType));
    }
}

