/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.service;

import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.io.EzyMaps;
import com.tvd12.ezyfox.io.EzySets;
import com.tvd12.ezyfox.util.Next;
import com.tvd12.ezyhttp.server.core.annotation.Service;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.admin.converter.AdminEntityToModelConverter;
import org.youngmonkeys.ezyplatform.admin.converter.AdminModelToEntityConverter;
import org.youngmonkeys.ezyplatform.admin.model.AddUserRoleModel;
import org.youngmonkeys.ezyplatform.admin.model.AddUserRoleNameModel;
import org.youngmonkeys.ezyplatform.admin.model.UpdateUserRoleNameModel;
import org.youngmonkeys.ezyplatform.admin.repo.AdminUserRoleNameRepository;
import org.youngmonkeys.ezyplatform.admin.repo.AdminUserRoleRepository;
import org.youngmonkeys.ezyplatform.entity.UserRole;
import org.youngmonkeys.ezyplatform.entity.UserRoleId;
import org.youngmonkeys.ezyplatform.entity.UserRoleName;
import org.youngmonkeys.ezyplatform.model.UserRoleModel;
import org.youngmonkeys.ezyplatform.model.UserRoleNameModel;
import org.youngmonkeys.ezyplatform.repo.UserRoleNameRepository;
import org.youngmonkeys.ezyplatform.repo.UserRoleRepository;
import org.youngmonkeys.ezyplatform.rx.Reactive;
import org.youngmonkeys.ezyplatform.rx.RxValueMap;
import org.youngmonkeys.ezyplatform.service.DefaultUserRoleService;

@Service
public class AdminUserRoleService
extends DefaultUserRoleService {
    private final AdminUserRoleRepository userRoleRepository;
    private final AdminUserRoleNameRepository userRoleNameRepository;
    private final AdminModelToEntityConverter modelToEntityConverter;
    private final AdminEntityToModelConverter entityToModelConverter;

    public AdminUserRoleService(AdminUserRoleRepository userRoleRepository, AdminUserRoleNameRepository userRoleNameRepository, AdminModelToEntityConverter modelToEntityConverter, AdminEntityToModelConverter entityToModelConverter) {
        super((UserRoleRepository)userRoleRepository, (UserRoleNameRepository)userRoleNameRepository);
        this.userRoleRepository = userRoleRepository;
        this.userRoleNameRepository = userRoleNameRepository;
        this.modelToEntityConverter = modelToEntityConverter;
        this.entityToModelConverter = entityToModelConverter;
    }

    public void saveUserRole(AddUserRoleModel model) {
        UserRole entity = (UserRole)this.userRoleRepository.findById(new UserRoleId(model.getRoleId(), model.getUserId()));
        if (entity == null) {
            entity = this.modelToEntityConverter.toEntity(model);
            this.userRoleRepository.save(entity);
        }
    }

    public void saveUserRoles(List<AddUserRoleModel> userRoleModels) {
        userRoleModels.forEach(this::saveUserRole);
    }

    public void deleteUserRole(long roleId, long userId) {
        this.userRoleRepository.delete(new UserRoleId(roleId, userId));
    }

    public UserRoleNameModel saveUserRoleNameIfNotExists(AddUserRoleNameModel model) {
        UserRoleNameModel existing = this.getUserRoleNameByNameOrDisplayName(model.getName(), model.getDisplayName());
        if (existing != null) {
            return existing;
        }
        return this.saveUserRoleName(model);
    }

    public UserRoleNameModel saveUserRoleName(AddUserRoleNameModel model) {
        UserRoleName entity = this.modelToEntityConverter.toEntity(model);
        this.userRoleNameRepository.save(entity);
        return this.entityToModelConverter.toModel(entity);
    }

    public void saveUserRoleName(UpdateUserRoleNameModel model) {
        UserRoleName entity = (UserRoleName)this.userRoleNameRepository.findById(model.getId());
        this.modelToEntityConverter.mergeToEntity(model, entity);
        this.userRoleNameRepository.save(entity);
    }

    public void deleteUserRoleNameById(long roleId) {
        this.userRoleNameRepository.delete(roleId);
    }

    public void removeUserRoles(long userId) {
        this.userRoleRepository.deleteByUserId(userId);
    }

    public void removeUsersRoles(Collection<Long> userIds) {
        if (!userIds.isEmpty()) {
            this.userRoleRepository.deleteByUserIdIn(userIds);
        }
    }

    public void replaceUserRoles(long userId, Collection<Long> roleIds) {
        Set needToAddRoleIds;
        List currentUserRoles = this.userRoleRepository.findListByField("userId", userId);
        List currentUserRoleIds = EzyLists.newArrayList((Collection)currentUserRoles, UserRole::identifier);
        Set currentRoleIds = EzySets.newHashSet((Collection)currentUserRoleIds, UserRoleId::getRoleId);
        List needToRemoveUserRoleIds = currentUserRoleIds.stream().filter(it -> !roleIds.contains(it.getRoleId())).collect(Collectors.toList());
        if (!needToRemoveUserRoleIds.isEmpty()) {
            this.userRoleRepository.deleteByIds(needToRemoveUserRoleIds);
        }
        if (!(needToAddRoleIds = roleIds.stream().filter(it -> !currentRoleIds.contains(it)).collect(Collectors.toSet())).isEmpty()) {
            this.saveUserRoles(EzyLists.newArrayList(needToAddRoleIds, it -> new AddUserRoleModel(userId, (long)it)));
        }
    }

    public List<UserRoleNameModel> getUserRoleNames() {
        return this.getUserRoleNames(3000);
    }

    public List<UserRoleNameModel> getUserRoleNames(int limit) {
        return EzyLists.newArrayList(this.userRoleNameRepository.findAllOrderByPriorityId(Next.limit((long)limit)), arg_0 -> ((AdminEntityToModelConverter)this.entityToModelConverter).toModel(arg_0));
    }

    public List<UserRoleNameModel> getUserRoles() {
        return EzyLists.newArrayList((Collection)this.userRoleNameRepository.findAll(), arg_0 -> ((AdminEntityToModelConverter)this.entityToModelConverter).toModel(arg_0));
    }

    public List<UserRoleNameModel> getUserRolesByIds(Collection<Long> roleIds) {
        if (roleIds.isEmpty()) {
            return Collections.emptyList();
        }
        return EzyLists.newArrayList((Collection)this.userRoleNameRepository.findListByIds(roleIds), arg_0 -> ((AdminEntityToModelConverter)this.entityToModelConverter).toModel(arg_0));
    }

    public List<UserRoleNameModel> getUserRolesByUserId(long userId) {
        List roleIds = EzyLists.newArrayList((Collection)this.userRoleRepository.findListByField("userId", userId), UserRole::getRoleId);
        return this.getUserRolesByIds(roleIds);
    }

    public UserRoleNameModel getUserRoleNameById(long id) {
        return this.entityToModelConverter.toModel((UserRoleName)this.userRoleNameRepository.findById(id));
    }

    public UserRoleNameModel getUserRoleNameByName(String name) {
        return this.entityToModelConverter.toModel((UserRoleName)this.userRoleNameRepository.findByField("name", name));
    }

    public UserRoleNameModel getUserRoleNameByNameOrDisplayName(String name, String displayName) {
        RxValueMap map = (RxValueMap)Reactive.multiple().register((Object)"name", () -> (UserRoleName)this.userRoleNameRepository.findByField("name", name)).register((Object)"displayName", () -> (UserRoleName)this.userRoleNameRepository.findByField("displayName", displayName)).blockingGet();
        UserRoleName entity = (UserRoleName)map.firstValueOrNull();
        return this.entityToModelConverter.toModel(entity);
    }

    public List<UserRoleModel> getUserRolesByRoleIdAndUserIds(long roleId, Collection<Long> userIds) {
        if (userIds.isEmpty()) {
            return Collections.emptyList();
        }
        return EzyLists.newArrayList(this.userRoleRepository.findByRoleIdAndUserIdIn(roleId, userIds), arg_0 -> ((AdminEntityToModelConverter)this.entityToModelConverter).toModel(arg_0));
    }

    public Map<Long, UserRoleModel> getUserRoleMapByRoleIdAndUserIds(long roleId, Collection<Long> userIds) {
        return EzyMaps.newHashMap(this.getUserRolesByRoleIdAndUserIds(roleId, userIds), UserRoleModel::getUserId);
    }

    public boolean containsUserRoleName(long roleId) {
        return this.userRoleNameRepository.containsById(roleId);
    }

    public boolean containsAllUserRoleIds(Collection<Long> roleIds) {
        return this.getUserRolesByIds(roleIds).size() == roleIds.size();
    }

    public long countAllRoles() {
        return this.userRoleNameRepository.count();
    }
}

