/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.mapping.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.tvd12.ezyfox.json.EzyJsonMapper;
import com.tvd12.ezyfox.mapping.jackson.EzyObjectMapperBuilder;
import com.tvd12.ezyfox.util.EzyLoggable;

public class EzySimpleJsonMapper
extends EzyLoggable
implements EzyJsonMapper {
    private final ObjectMapper mapper = EzyObjectMapperBuilder.objectMapperBuilder().build();

    public EzySimpleJsonMapper() {
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    }

    public String writeAsString(Object object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            this.logger.error("can not read object {}", object, (Object)e);
            return null;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        public EzySimpleJsonMapper build() {
            return new EzySimpleJsonMapper();
        }
    }
}

