/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.nio.udp;

import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyfoxserver.nio.handler.EzyNioUdpDataHandler;
import com.tvd12.ezyfoxserver.socket.EzySimpleUdpReceivedPacket;
import com.tvd12.ezyfoxserver.socket.EzySocketAbstractEventHandler;
import com.tvd12.ezyfoxserver.socket.EzyUdpReceivedPacket;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import lombok.Generated;

public class EzyNioUdpReader
extends EzySocketAbstractEventHandler {
    protected final ByteBuffer buffer;
    protected Selector ownSelector;
    protected EzyNioUdpDataHandler udpDataHandler;

    public EzyNioUdpReader(int maxBufferSize) {
        this.buffer = ByteBuffer.allocateDirect(maxBufferSize);
    }

    public void destroy() {
        EzyProcessor.processWithLogException(() -> this.ownSelector.close());
    }

    public void handleEvent() {
        try {
            this.processReadyKeys();
        }
        catch (Throwable e) {
            this.logger.info("I/O error at udp socket-reader: {}({})", (Object)e.getClass().getName(), (Object)e.getMessage());
        }
    }

    private void processReadyKeys() throws Exception {
        this.ownSelector.select();
        Set<SelectionKey> selectedKeys = this.ownSelector.selectedKeys();
        Iterator<SelectionKey> iterator = selectedKeys.iterator();
        while (iterator.hasNext()) {
            SelectionKey key = iterator.next();
            iterator.remove();
            if (!key.isValid()) continue;
            this.processReadyKey(key);
        }
    }

    private void processReadyKey(SelectionKey key) {
        if (key.isReadable()) {
            this.processReadableKey(key);
        }
    }

    private void processReadableKey(SelectionKey key) {
        DatagramChannel channel = (DatagramChannel)key.channel();
        try {
            this.processReadBytes(channel);
        }
        catch (ClosedSelectorException e) {
            this.logger.debug("selector has already closed: {}", (Object)e.getMessage());
        }
        catch (CancelledKeyException e) {
            this.logger.debug("key has already cancelled: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            this.logger.warn("io exception: {}", (Object)e.getMessage());
        }
        catch (Throwable e) {
            this.logger.error("fatal error at udp socket-reader", e);
        }
    }

    private void processReadBytes(DatagramChannel channel) throws Exception {
        this.buffer.clear();
        InetSocketAddress address = (InetSocketAddress)channel.receive(this.buffer);
        if (address == null) {
            this.logger.info("has no data in udp channel: {}", (Object)channel);
            return;
        }
        int byteCount = this.buffer.position();
        if (byteCount > 0) {
            this.buffer.flip();
            byte[] binary = new byte[this.buffer.limit()];
            this.buffer.get(binary);
            EzySimpleUdpReceivedPacket packet = new EzySimpleUdpReceivedPacket(channel, address, binary);
            this.udpDataHandler.fireUdpPacketReceived((EzyUdpReceivedPacket)packet);
        }
    }

    @Generated
    public void setOwnSelector(Selector ownSelector) {
        this.ownSelector = ownSelector;
    }

    @Generated
    public void setUdpDataHandler(EzyNioUdpDataHandler udpDataHandler) {
        this.udpDataHandler = udpDataHandler;
    }
}

