/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.nio.wrapper.impl;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfoxserver.constant.EzyConnectionType;
import com.tvd12.ezyfoxserver.entity.EzySession;
import com.tvd12.ezyfoxserver.nio.factory.EzyHandlerGroupBuilderFactory;
import com.tvd12.ezyfoxserver.nio.handler.EzyHandlerGroup;
import com.tvd12.ezyfoxserver.nio.wrapper.EzyHandlerGroupManager;
import com.tvd12.ezyfoxserver.socket.EzyChannel;
import com.tvd12.ezyfoxserver.socket.EzySocketDataHandlerGroup;
import com.tvd12.ezyfoxserver.socket.EzySocketWriterGroup;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EzyHandlerGroupManagerImpl
extends EzyLoggable
implements EzyHandlerGroupManager {
    private final Map<Object, Object> socketChannelByUdpAddress;
    private final Map<Object, EzyHandlerGroup> groupsByConnection;
    private final EzyHandlerGroupBuilderFactory handlerGroupBuilderFactory;

    public EzyHandlerGroupManagerImpl(Builder builder) {
        this.handlerGroupBuilderFactory = builder.handlerGroupBuilderFactory;
        this.groupsByConnection = new ConcurrentHashMap<Object, EzyHandlerGroup>();
        this.socketChannelByUdpAddress = new ConcurrentHashMap<Object, Object>();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public <T extends EzyHandlerGroup> T newHandlerGroup(EzyChannel channel, EzyConnectionType type) {
        EzyHandlerGroup group = (EzyHandlerGroup)this.handlerGroupBuilderFactory.newBuilder(channel, type).build();
        this.groupsByConnection.put(channel.getConnection(), group);
        return (T)group;
    }

    @Override
    public <T extends EzyHandlerGroup> T getHandlerGroup(Object connection) {
        return (T)this.groupsByConnection.get(connection);
    }

    private EzyHandlerGroup getHandlerGroup(EzySession session) {
        if (session == null) {
            return null;
        }
        EzyChannel channel = session.getChannel();
        if (channel == null) {
            return null;
        }
        Object connection = channel.getConnection();
        if (connection == null) {
            return null;
        }
        return this.groupsByConnection.get(connection);
    }

    @Override
    public void unmapHandlerGroup(SocketAddress udpAddress) {
        if (udpAddress != null) {
            this.socketChannelByUdpAddress.remove(udpAddress);
            this.logger.debug("unmap socket channel from: {}, socketChannelByUdpAddress.size: {}", (Object)udpAddress, (Object)this.socketChannelByUdpAddress.size());
        }
    }

    @Override
    public void mapSocketChannel(SocketAddress udpAddress, EzySession session) {
        if (session == null) {
            return;
        }
        EzyChannel channel = session.getChannel();
        if (channel == null) {
            return;
        }
        Object connection = channel.getConnection();
        if (connection == null) {
            return;
        }
        if (this.groupsByConnection.containsKey(connection)) {
            this.socketChannelByUdpAddress.put(udpAddress, connection);
        }
        this.logger.debug("map socket channel to: {}, socketChannelByUdpAddress.size: {}", (Object)udpAddress, (Object)this.socketChannelByUdpAddress.size());
    }

    @Override
    public Object getSocketChannel(SocketAddress udpAddress) {
        return this.socketChannelByUdpAddress.get(udpAddress);
    }

    public EzySocketDataHandlerGroup removeHandlerGroup(EzySession session) {
        if (session == null) {
            return null;
        }
        EzyChannel channel = session.getChannel();
        if (channel == null) {
            return null;
        }
        Object connection = channel.getConnection();
        if (connection == null) {
            return null;
        }
        EzyHandlerGroup group = this.groupsByConnection.remove(connection);
        SocketAddress udpClientAddress = session.getUdpClientAddress();
        if (udpClientAddress != null) {
            this.socketChannelByUdpAddress.remove(udpClientAddress);
        }
        this.logger.debug("remove handler group: {} with session: {}, groupsByConnection.size: {}, socketChannelByUdpAddress.size: {}", new Object[]{group, session, this.groupsByConnection.size(), this.socketChannelByUdpAddress.size()});
        return group;
    }

    public EzySocketDataHandlerGroup getDataHandlerGroup(EzySession session) {
        return this.getHandlerGroup(session);
    }

    public EzySocketWriterGroup getWriterGroup(EzySession session) {
        return this.getHandlerGroup(session);
    }

    public void destroy() {
        this.groupsByConnection.clear();
    }

    public static class Builder
    implements EzyBuilder<EzyHandlerGroupManager> {
        private EzyHandlerGroupBuilderFactory handlerGroupBuilderFactory;

        public Builder handlerGroupBuilderFactory(EzyHandlerGroupBuilderFactory factory) {
            this.handlerGroupBuilderFactory = factory;
            return this;
        }

        public EzyHandlerGroupManager build() {
            return new EzyHandlerGroupManagerImpl(this);
        }
    }
}

