/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.handler;

import com.tvd12.ezyfox.constant.EzyConstant;
import com.tvd12.ezyfox.exception.EzyMaxRequestSizeException;
import com.tvd12.ezyfox.util.EzyDestroyable;
import com.tvd12.ezyfox.util.EzyExceptionHandler;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfoxserver.EzyServer;
import com.tvd12.ezyfoxserver.command.EzyCloseSession;
import com.tvd12.ezyfoxserver.constant.EzyDisconnectReason;
import com.tvd12.ezyfoxserver.constant.EzySessionError;
import com.tvd12.ezyfoxserver.context.EzyServerContext;
import com.tvd12.ezyfoxserver.context.EzyZoneContext;
import com.tvd12.ezyfoxserver.delegate.EzySessionDelegate;
import com.tvd12.ezyfoxserver.entity.EzyAbstractSession;
import com.tvd12.ezyfoxserver.entity.EzySession;
import com.tvd12.ezyfoxserver.entity.EzyUser;
import com.tvd12.ezyfoxserver.response.EzyErrorParams;
import com.tvd12.ezyfoxserver.response.EzyErrorResponse;
import com.tvd12.ezyfoxserver.response.EzyResponse;
import com.tvd12.ezyfoxserver.setting.EzySessionManagementSetting;
import com.tvd12.ezyfoxserver.setting.EzySettings;
import com.tvd12.ezyfoxserver.socket.EzyChannel;
import com.tvd12.ezyfoxserver.wrapper.EzyServerControllers;
import com.tvd12.ezyfoxserver.wrapper.EzySessionManager;
import com.tvd12.ezyfoxserver.wrapper.EzyZoneUserManager;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class EzyAbstractDataHandler<S extends EzySession>
extends EzyLoggable
implements EzySessionDelegate,
EzyDestroyable {
    protected final Lock lock = new ReentrantLock();
    protected S session;
    protected EzyChannel channel;
    protected EzyUser user;
    protected EzyServer server;
    protected EzyServerContext context;
    protected EzyZoneContext zoneContext;
    protected EzyCloseSession closeSession;
    protected EzyServerControllers controllers;
    protected EzyZoneUserManager userManager;
    protected EzySessionManager sessionManager;
    protected EzySettings settings;
    protected Set<EzyConstant> ignoredLogCommands;
    protected EzySessionManagementSetting sessionManagementSetting;
    protected EzySessionManagementSetting.EzyMaxRequestPerSecond maxRequestPerSecond;
    protected volatile boolean active = true;
    protected volatile boolean destroyed = false;
    protected Map<Class<?>, EzyExceptionHandler> exceptionHandlers = this.newExceptionHandlers();

    public EzyAbstractDataHandler(EzyServerContext ctx, S session) {
        this.context = ctx;
        this.session = session;
        this.channel = session.getChannel();
        this.server = this.context.getServer();
        this.controllers = this.server.getControllers();
        this.sessionManager = this.server.getSessionManager();
        this.closeSession = this.context.get(EzyCloseSession.class);
        this.settings = this.server.getSettings();
        this.sessionManagementSetting = this.settings.getSessionManagement();
        this.maxRequestPerSecond = this.sessionManagementSetting.getSessionMaxRequestPerSecond();
        this.ignoredLogCommands = this.settings.getLogger().getIgnoredCommands().getCommands();
        ((EzyAbstractSession)this.session).setDelegate(this);
    }

    protected EzyZoneUserManager getUserManager(int zoneId) {
        EzyZoneContext zoneContext = this.context.getZoneContext(zoneId);
        return zoneContext.getZone().getUserManager();
    }

    protected void response(EzyResponse response) {
        if (this.context != null) {
            this.context.send(response, (EzySession)this.session, false);
        }
    }

    protected void responseError() {
        EzyErrorParams params = new EzyErrorParams();
        params.setError(EzySessionError.MAX_REQUEST_PER_SECOND);
        this.response(new EzyErrorResponse(params));
    }

    private Map<Class<?>, EzyExceptionHandler> newExceptionHandlers() {
        ConcurrentHashMap handlers = new ConcurrentHashMap();
        handlers.put(EzyMaxRequestSizeException.class, (thread, throwable) -> {
            if (this.sessionManager != null) {
                this.sessionManager.removeSession(this.session, EzyDisconnectReason.MAX_REQUEST_SIZE);
            }
        });
        return handlers;
    }

    public void destroy() {
        this.active = false;
        this.destroyed = true;
        if (this.session != null) {
            this.session.destroy();
        }
        this.session = null;
        this.channel = null;
        this.server = null;
        this.user = null;
        this.context = null;
        this.zoneContext = null;
        this.controllers = null;
        this.userManager = null;
        this.closeSession = null;
        this.sessionManager = null;
        this.settings = null;
        this.ignoredLogCommands = null;
        this.sessionManagementSetting = null;
        if (this.exceptionHandlers != null) {
            this.exceptionHandlers.clear();
        }
        this.exceptionHandlers = null;
    }

    public String toString() {
        return "(\n\tactive: " + this.active + "\n\tsession: " + this.session + "\n\tchannel: " + this.channel + "\n\tserver: " + this.server + "\n\tuser: " + this.user + "\n\tcontext: " + this.context + "\n\tzoneContext: " + this.zoneContext + "\n\tcontrollers: " + this.controllers + "\n\tuserManager: " + this.userManager + "\n\tcloseSession: " + this.closeSession + "\n\tsessionManager: " + this.sessionManager + "\n\tlock: " + this.lock + "\n\tsettings: " + this.settings + "\n\tignoredLogCommands: " + this.ignoredLogCommands + "\n\tsessionManagementSetting: " + this.sessionManagementSetting + "\n\texceptionHandlers: " + this.exceptionHandlers + "\n)";
    }
}

