/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.manager;

import com.tvd12.ezyfox.bean.EzySingletonFactory;
import com.tvd12.ezyfox.concurrent.EzyLazyInitializer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.fetcher.CommonEntityFetcher;
import org.youngmonkeys.ezyplatform.model.CommonEntityModel;

public class CommonEntityFetcherManager {
    private final EzyLazyInitializer<Map<String, CommonEntityFetcher>> accountingEntityFetcherByEntityType = new EzyLazyInitializer(() -> {
        List beans = singletonFactory.getSingletonsOf(CommonEntityFetcher.class);
        HashMap<String, CommonEntityFetcher> map = new HashMap<String, CommonEntityFetcher>();
        for (CommonEntityFetcher fetcher : beans) {
            map.compute(fetcher.getEntityType(), (k, v) -> v == null || fetcher.getPriority() >= v.getPriority() ? fetcher : v);
        }
        List<CommonEntityFetcher> prioritizedBeans = this.getPrioritizedEntityFetchers(singletonFactory);
        for (CommonEntityFetcher fetcher : prioritizedBeans) {
            map.put(fetcher.getEntityType(), fetcher);
        }
        return map;
    });
    private final Map<String, CommonEntityFetcher> additionalFetcherByEntityType = new HashMap<String, CommonEntityFetcher>();

    public CommonEntityFetcherManager(EzySingletonFactory singletonFactory) {
    }

    protected List<CommonEntityFetcher> getPrioritizedEntityFetchers(EzySingletonFactory singletonFactory) {
        return Collections.emptyList();
    }

    public void addEntityFetcher(CommonEntityFetcher fetcher) {
        this.additionalFetcherByEntityType.put(fetcher.getEntityType(), fetcher);
    }

    public CommonEntityFetcher getEntityFetcherByEntityType(String entityType) {
        return this.additionalFetcherByEntityType.getOrDefault(entityType, (CommonEntityFetcher)((Map)this.accountingEntityFetcherByEntityType.get()).get(entityType));
    }

    public CommonEntityModel getEntityEntityTypeAndId(String entityType, long entityId) {
        CommonEntityFetcher fetcher = this.getEntityFetcherByEntityType(entityType);
        return fetcher != null ? fetcher.getEntityById(entityId) : CommonEntityModel.defaultEntity(entityId, entityType);
    }

    public Map<Long, CommonEntityModel> getEntityMapByEntityTypeAndIds(String entityType, Collection<Long> entityIds) {
        CommonEntityFetcher fetcher = this.getEntityFetcherByEntityType(entityType);
        return fetcher != null ? fetcher.getEntityMapByIds(entityIds) : Collections.emptyMap();
    }

    public Map<String, Map<Long, CommonEntityModel>> getEntityMapByEntityIdsByType(Map<String, Set<Long>> entityIdsByType) {
        return entityIdsByType.entrySet().parallelStream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.getEntityMapByEntityTypeAndIds((String)e.getKey(), (Collection)e.getValue())));
    }
}

