/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.util.Collection;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.converter.DefaultModelToEntityConverter;
import org.youngmonkeys.ezyplatform.model.SaveDataKeywordModel;
import org.youngmonkeys.ezyplatform.repo.DataIndexRepository;
import org.youngmonkeys.ezyplatform.repo.DataIndexTransactionalRepository;
import org.youngmonkeys.ezyplatform.service.DataIndexService;

public class DefaultDataIndexService
extends EzyLoggable
implements DataIndexService {
    private final DataIndexRepository dataIndexRepository;
    private final DataIndexTransactionalRepository dataIndexTransactionalRepository;
    private final DefaultModelToEntityConverter modelToEntityConverter;

    @Override
    public void saveKeyword(String dataType, SaveDataKeywordModel model) {
        this.dataIndexTransactionalRepository.saveDataIndex(this.modelToEntityConverter.toEntity(dataType, model));
    }

    @Override
    public void saveKeywords(String dataType, Collection<SaveDataKeywordModel> dataKeywords) {
        this.dataIndexTransactionalRepository.saveDataIndices(EzyLists.newArrayList(dataKeywords, it -> this.modelToEntityConverter.toEntity(dataType, (SaveDataKeywordModel)it)));
    }

    @Override
    public void deleteKeywordsByDataTypeAndDataId(String dataType, long dataId) {
        this.dataIndexRepository.deleteByDataTypeAndDataId(dataType, dataId);
    }

    @Override
    public void deleteKeywordsByDataTypeAndDataIds(String dataType, Collection<Long> dataIds) {
        if (!dataIds.isEmpty()) {
            this.dataIndexRepository.deleteByDataTypeAndDataIdIn(dataType, dataIds);
        }
    }

    @Override
    public boolean containsDataIndex(String dataType, long dataId, String keyword) {
        return this.dataIndexRepository.findByDataTypeAndDataIdAndKeyword(dataType, dataId, keyword) != null;
    }

    @Generated
    public DefaultDataIndexService(DataIndexRepository dataIndexRepository, DataIndexTransactionalRepository dataIndexTransactionalRepository, DefaultModelToEntityConverter modelToEntityConverter) {
        this.dataIndexRepository = dataIndexRepository;
        this.dataIndexTransactionalRepository = dataIndexTransactionalRepository;
        this.modelToEntityConverter = modelToEntityConverter;
    }
}

