/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.tvd12.ezyfox.io.EzyCollections;
import com.tvd12.ezyfox.io.EzySets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.entity.UserRole;
import org.youngmonkeys.ezyplatform.entity.UserRoleId;
import org.youngmonkeys.ezyplatform.entity.UserRoleName;
import org.youngmonkeys.ezyplatform.repo.UserRoleNameRepository;
import org.youngmonkeys.ezyplatform.repo.UserRoleRepository;
import org.youngmonkeys.ezyplatform.service.UserRoleService;

public class DefaultUserRoleService
implements UserRoleService {
    private final UserRoleRepository userRoleRepository;
    private final UserRoleNameRepository userRoleNameRepository;

    @Override
    public long getRoleIdByName(String roleName) {
        UserRoleName userRoleName = (UserRoleName)this.userRoleNameRepository.findByField("name", roleName);
        return userRoleName == null ? 0L : userRoleName.getId();
    }

    @Override
    public Set<Long> getRoleIdsByNames(Collection<String> roleNames) {
        if (EzyCollections.isEmpty(roleNames)) {
            return Collections.emptySet();
        }
        return this.userRoleNameRepository.findByNameIn(roleNames).stream().map(UserRoleName::getId).collect(Collectors.toSet());
    }

    @Override
    public Map<String, Long> getRoleIdMapByNames(Collection<String> roleNames) {
        if (EzyCollections.isEmpty(roleNames)) {
            return Collections.emptyMap();
        }
        return this.userRoleNameRepository.findByNameIn(roleNames).stream().collect(Collectors.toMap(UserRoleName::getName, UserRoleName::getId));
    }

    @Override
    public Set<Long> getRoleIdsByUserId(long userId) {
        return EzySets.newHashSet((Collection)this.userRoleRepository.findListByField("userId", userId), UserRole::getRoleId);
    }

    @Override
    public Set<Long> getUserIdsByRoleId(long roleId, int limit) {
        return EzySets.newHashSet((Collection)this.userRoleRepository.findListByField("roleId", roleId, 0, limit), UserRole::getUserId);
    }

    @Override
    public Set<Long> getUserIdsByRoleName(String roleName, int limit) {
        long roleId = this.getRoleIdByName(roleName);
        return roleId > 0L ? this.getUserIdsByRoleId(roleId, limit) : Collections.emptySet();
    }

    @Override
    public boolean containsUserRole(long userId, long roleId) {
        return this.userRoleRepository.containsById(new UserRoleId(roleId, userId));
    }

    @Override
    public boolean containsUserRole(long userId, String roleName) {
        UserRoleName userRoleName = (UserRoleName)this.userRoleNameRepository.findByField("name", roleName);
        return userRoleName != null && this.containsUserRole(userId, userRoleName.getId());
    }

    @Override
    public boolean containsUserRole(String username, String roleName) {
        return this.userRoleRepository.findByUsernameAndRoleName(username, roleName) != null;
    }

    @Generated
    public DefaultUserRoleService(UserRoleRepository userRoleRepository, UserRoleNameRepository userRoleNameRepository) {
        this.userRoleRepository = userRoleRepository;
        this.userRoleNameRepository = userRoleNameRepository;
    }
}

