/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.util;

import com.tvd12.ezyfox.io.EzyBytes;
import com.tvd12.ezyfox.io.EzyLongs;
import com.tvd12.ezyfox.security.EzyAesCrypt;
import com.tvd12.ezyfox.security.EzyBase64;
import com.tvd12.ezyfox.security.EzySHA256;
import java.util.UUID;

public final class AccessTokens {
    private AccessTokens() {
    }

    public static String generateAccessToken(String source, long sourceId, byte[] encryptionKey) {
        byte[] encryptedSourceIdBytes;
        if (encryptionKey == null) {
            throw new IllegalStateException("server's not ready yet");
        }
        try {
            byte[] sourceIdBytes = EzyBytes.getBytes((long)sourceId);
            encryptedSourceIdBytes = EzyAesCrypt.getDefault().encrypt(sourceIdBytes, encryptionKey);
        }
        catch (Exception e) {
            throw new IllegalStateException("can not generate access token for " + source + " id: " + sourceId, e);
        }
        String header = EzyBase64.encode2utf((byte[])encryptedSourceIdBytes);
        String body = EzySHA256.cryptUtfToLowercase((String)(String.valueOf(sourceId) + '-' + UUID.randomUUID() + '-' + System.currentTimeMillis()));
        return header + body;
    }

    public static long extractSourceId(String accessToken, byte[] encryptionKey) {
        if (encryptionKey == null) {
            throw new IllegalStateException("server's not ready yet");
        }
        try {
            String base64Header = accessToken.substring(0, 44);
            byte[] encryptedSourceIdBytes = EzyBase64.decode((String)base64Header);
            byte[] sourceIdBytes = EzyAesCrypt.getDefault().decrypt(encryptedSourceIdBytes, encryptionKey);
            return EzyLongs.bin2long((byte[])sourceIdBytes);
        }
        catch (Exception e) {
            return 0L;
        }
    }
}

