/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.validator;

import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.properties.file.util.PropertiesUtil;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.util.Collection;

public final class DefaultValidator {
    private DefaultValidator() {
    }

    public static boolean isValidUIntNumber(String value) {
        return value != null && value.matches("[0-9]+");
    }

    public static boolean isValidUuid(String uuid) {
        return uuid != null && uuid.length() <= 128;
    }

    public static boolean isValidEmail(String email) {
        return email != null && email.length() <= 128 && email.matches("^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,9}$");
    }

    public static boolean isValidUsername(String username) {
        return username != null && username.matches("[a-zA-Z0-9_.-]{3,64}");
    }

    public static boolean isValidPassword(String password) {
        return password != null && password.length() >= 6 && password.length() <= 128;
    }

    public static boolean isValidPhone(String phone) {
        return phone != null && phone.length() >= 6 && phone.length() <= 20 && phone.matches("(^(\\+\\d{1,2}\\s)?\\(?\\d{3}\\)?[\\s.-]\\d{3}[\\s.-]\\d{4}$)|(^(\\+\\d{1,2})?[\\d]{6,15})");
    }

    public static boolean isValidUrl(String url) {
        try {
            new URI(url);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isValidExternalUrl(String url) {
        try {
            URI uri = new URI(url);
            String scheme = uri.getScheme();
            String host = uri.getHost();
            return scheme.equals("https") && EzyStrings.isNotBlank((String)host) && !host.equals("localhost") && DefaultValidator.isPublicHost(host) && !host.matches("^\\d{1,3}(\\.\\d{1,3}){3}$") && uri.getUserInfo() == null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isPublicHost(String host) {
        try {
            InetAddress[] addresses;
            for (InetAddress address : addresses = InetAddress.getAllByName(host)) {
                if (!DefaultValidator.isInternalNetworkAddress(address)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isInternalNetworkAddress(InetAddress address) {
        byte[] b;
        if (address.isAnyLocalAddress() || address.isLoopbackAddress() || address.isLinkLocalAddress()) {
            return true;
        }
        if (address instanceof Inet4Address) {
            b = address.getAddress();
            int first = Byte.toUnsignedInt(b[0]);
            int second = Byte.toUnsignedInt(b[1]);
            if (first == 10) {
                return true;
            }
            if (first == 172 && second >= 16 && second <= 31) {
                return true;
            }
            if (first == 192 && second == 168) {
                return true;
            }
            if (first == 169 && second == 254) {
                return true;
            }
        }
        if (address instanceof Inet6Address) {
            if (address.isLoopbackAddress()) {
                return true;
            }
            b = address.getAddress();
            int firstByte = Byte.toUnsignedInt(b[0]);
            return (firstByte & 0xFE) == 252;
        }
        return false;
    }

    public static boolean isValidHttpUrl(String url) {
        return url != null && url.length() >= 8 && url.length() <= 256 && url.matches("https?:\\/\\/(www\\.)?[-a-zA-Z0-9@:%._\\+~#=]{1,256}\\.?[a-zA-Z0-9()]{1,6}\\b([-a-zA-Z0-9()@:%_\\+.~#?&//=]*)");
    }

    public static boolean isValidWebsocketUrl(String url) {
        return url != null && url.length() >= 8 && url.length() <= 256 && url.matches("wss?:\\/\\/[-a-zA-Z0-9@:%._\\+~#=]{1,256}\\.?[a-zA-Z0-9()]{1,6}\\b([-a-zA-Z0-9()@:%_\\+.~#?&//=]*)");
    }

    public static boolean isValidMediaName(String mediaName) {
        return mediaName != null && mediaName.matches("^[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)*$");
    }

    public static boolean isValidVersion(String version) {
        return version != null && version.matches("[0-9]+[\\.][0-9]+[\\.][0-9]+");
    }

    public static boolean isSha256String(String str) {
        return str != null && str.matches("[a-fA-F0-9\\s]{64}");
    }

    public static boolean isCommonString(String str, int maxLength) {
        return DefaultValidator.isCommonString(str, 1, maxLength);
    }

    public static boolean isCommonString(String str, int minLength, int maxLength) {
        return EzyStrings.isNotBlank((String)str) && str.length() >= minLength && str.length() <= maxLength && str.matches("[a-zA-Z0-9\\s]+");
    }

    public static boolean isPackageName(String str, int minLength, int maxLength) {
        return EzyStrings.isNotBlank((String)str) && str.length() >= minLength && str.length() <= maxLength && str.matches("[a-z0-9_\\.]+");
    }

    public static boolean isIntegerNumber(String value) {
        try {
            Long.parseLong(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isFloatNumber(String value) {
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isBoolean(String value) {
        try {
            return value.equals("true") || value.equals("false");
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean containsSqlComment(String str) {
        return str.contains("--");
    }

    public static boolean containsOperation(String str) {
        return str.contains("=") || str.contains(">") || str.contains("<");
    }

    public static boolean containsParentheses(String str) {
        return str.contains("'");
    }

    public static boolean maybeContainsSqlInjection(String str) {
        return DefaultValidator.containsSqlComment(str) || DefaultValidator.containsOperation(str) || DefaultValidator.containsParentheses(str);
    }

    public static boolean isValidPageSize(int pageSize) {
        return pageSize >= 1 && pageSize <= 300;
    }

    public static boolean isValidCollectionSize(Collection<?> collection) {
        return collection.size() >= 1 && collection.size() <= 300;
    }

    public static boolean isValidWebPageSize(int pageSize) {
        return pageSize >= 1 && pageSize <= 100;
    }

    public static boolean containsVariable(String text) {
        return PropertiesUtil.getKeysFromVariableName((String)text).size() > 0;
    }
}

