/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver;

import com.tvd12.ezyfoxserver.EzyPlugin;
import com.tvd12.ezyfoxserver.EzyZoneComponentsStater;
import com.tvd12.ezyfoxserver.context.EzyPluginContext;
import com.tvd12.ezyfoxserver.ext.EzyEntryAware;
import com.tvd12.ezyfoxserver.ext.EzyPluginEntry;
import com.tvd12.ezyfoxserver.ext.EzyPluginEntryLoader;
import com.tvd12.ezyfoxserver.setting.EzyPluginSetting;
import java.util.Set;

public class EzyPluginsStarter
extends EzyZoneComponentsStater {
    protected EzyPluginsStarter(Builder builder) {
        super(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void start() {
        this.startAllPlugins();
    }

    protected void startAllPlugins() {
        Set<String> pluginNames = this.getPluginNames();
        this.logger.info("start plugins: {}", pluginNames);
        for (String pluginName : pluginNames) {
            this.startPlugin(pluginName);
        }
    }

    protected void startPlugin(String pluginName) {
        try {
            this.logger.debug("plugin: {} loading...", (Object)pluginName);
            EzyPluginContext context = this.zoneContext.getPluginContext(pluginName);
            EzyPlugin plugin = context.getPlugin();
            EzyPluginEntry entry = this.startPlugin(pluginName, this.newPluginEntryLoader(pluginName));
            ((EzyEntryAware)((Object)plugin)).setEntry(entry);
            this.logger.debug("plugin: {} loaded", (Object)pluginName);
        }
        catch (Exception e) {
            this.logger.error("can not start plugin: {}", (Object)pluginName, (Object)e);
        }
    }

    protected EzyPluginEntry startPlugin(String pluginName, EzyPluginEntryLoader loader) throws Exception {
        EzyPluginEntry entry = loader.load();
        entry.config(this.getPluginContext(pluginName));
        entry.start();
        return entry;
    }

    protected Set<String> getPluginNames() {
        return this.zoneSetting.getPluginNames();
    }

    protected EzyPluginSetting getPluginByName(String name) {
        return this.zoneSetting.getPluginByName(name);
    }

    protected Class<EzyPluginEntryLoader> getPluginEntryLoaderClass(String pluginName) throws Exception {
        return this.getPluginEntryLoaderClass(this.getPluginByName(pluginName));
    }

    protected Class<EzyPluginEntryLoader> getPluginEntryLoaderClass(EzyPluginSetting plugin) throws Exception {
        return Class.forName(plugin.getEntryLoader());
    }

    protected EzyPluginEntryLoader newPluginEntryLoader(String pluginName) throws Exception {
        Class<EzyPluginEntryLoader> pluginLoaderClass = this.getPluginEntryLoaderClass(pluginName);
        EzyPluginSetting pluginSetting = this.getPluginByName(pluginName);
        if (pluginSetting.getEntryLoaderArgs() == null) {
            return pluginLoaderClass.newInstance();
        }
        return (EzyPluginEntryLoader)pluginLoaderClass.getConstructors()[0].newInstance(pluginSetting.getEntryLoaderArgs());
    }

    protected EzyPluginContext getPluginContext(String pluginName) {
        return this.zoneContext.getPluginContext(pluginName);
    }

    public static class Builder
    extends EzyZoneComponentsStater.Builder<EzyPluginsStarter, Builder> {
        public EzyPluginsStarter build() {
            return new EzyPluginsStarter(this);
        }
    }
}

