/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.context;

import com.tvd12.ezyfox.entity.EzyData;
import com.tvd12.ezyfox.util.EzyDestroyable;
import com.tvd12.ezyfox.util.EzyEquals;
import com.tvd12.ezyfox.util.EzyHashCodes;
import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyfoxserver.EzyApplication;
import com.tvd12.ezyfoxserver.EzyComponent;
import com.tvd12.ezyfoxserver.command.EzyAppResponse;
import com.tvd12.ezyfoxserver.command.EzyAppSendResponse;
import com.tvd12.ezyfoxserver.command.EzyAppSetup;
import com.tvd12.ezyfoxserver.command.EzyHandleException;
import com.tvd12.ezyfoxserver.command.EzySetup;
import com.tvd12.ezyfoxserver.command.impl.EzyAppHandleExceptionImpl;
import com.tvd12.ezyfoxserver.command.impl.EzyAppResponseImpl;
import com.tvd12.ezyfoxserver.command.impl.EzyAppSendResponseImpl;
import com.tvd12.ezyfoxserver.command.impl.EzyAppSetupImpl;
import com.tvd12.ezyfoxserver.constant.EzyTransportType;
import com.tvd12.ezyfoxserver.context.EzyAbstractZoneChildContext;
import com.tvd12.ezyfoxserver.context.EzyAppContext;
import com.tvd12.ezyfoxserver.entity.EzySession;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import lombok.Generated;

public class EzySimpleAppContext
extends EzyAbstractZoneChildContext
implements EzyAppContext {
    protected EzyApplication app;
    protected EzyAppSendResponse sendResponse;

    @Override
    protected void doInit() {
        EzyAppSetupImpl setup = new EzyAppSetupImpl(this.app);
        this.sendResponse = new EzyAppSendResponseImpl(this);
        this.properties.put(EzyAppSendResponse.class, this.sendResponse);
        this.properties.put(EzyHandleException.class, new EzyAppHandleExceptionImpl(this.app));
        this.properties.put(EzySetup.class, setup);
        this.properties.put(EzyAppSetup.class, setup);
    }

    @Override
    public void send(EzyData data, EzySession recipient, boolean encrypted, EzyTransportType transportType) {
        this.sendResponse.execute(data, recipient, encrypted, transportType);
    }

    @Override
    public void send(EzyData data, Collection<EzySession> recipients, boolean encrypted, EzyTransportType transportType) {
        this.sendResponse.execute(data, recipients, encrypted, transportType);
    }

    public void setApp(EzyApplication app) {
        this.app = app;
        this.component = (EzyComponent)((Object)app);
    }

    @Override
    protected void addCommandSuppliers(Map<Class, Supplier> suppliers) {
        suppliers.put(EzyAppResponse.class, () -> new EzyAppResponseImpl(this));
    }

    @Override
    public void destroy() {
        super.destroy();
        this.destroyApp();
        this.clearProperties();
    }

    protected void clearProperties() {
        this.app = null;
        this.sendResponse = null;
    }

    protected void destroyApp() {
        EzyProcessor.processWithLogException(() -> ((EzyDestroyable)this.app).destroy());
    }

    public boolean equals(Object obj) {
        return new EzyEquals().function(t -> t.app).isEquals((Object)this, obj);
    }

    public int hashCode() {
        return new EzyHashCodes().append((Object)this.app).toHashCode();
    }

    @Override
    protected void preDestroy() {
        this.logger.debug("destroy AppContext({})", (Object)this.app);
    }

    @Override
    @Generated
    public EzyApplication getApp() {
        return this.app;
    }
}

