/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.handler;

import com.tvd12.ezyfox.constant.EzyConstant;
import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfox.util.EzyExceptionHandler;
import com.tvd12.ezyfoxserver.constant.EzyCommand;
import com.tvd12.ezyfoxserver.constant.EzyDisconnectReason;
import com.tvd12.ezyfoxserver.constant.EzyEventType;
import com.tvd12.ezyfoxserver.constant.EzyMaxRequestPerSecondAction;
import com.tvd12.ezyfoxserver.context.EzyServerContext;
import com.tvd12.ezyfoxserver.controller.EzyController;
import com.tvd12.ezyfoxserver.controller.EzyStreamingController;
import com.tvd12.ezyfoxserver.entity.EzySession;
import com.tvd12.ezyfoxserver.event.EzyEvent;
import com.tvd12.ezyfoxserver.event.EzySimpleSessionRemovedEvent;
import com.tvd12.ezyfoxserver.exception.EzyRequestHandleException;
import com.tvd12.ezyfoxserver.handler.EzyUserDataHandler;
import com.tvd12.ezyfoxserver.interceptor.EzyInterceptor;
import com.tvd12.ezyfoxserver.request.EzyRequest;
import com.tvd12.ezyfoxserver.request.EzyStreamingRequest;

public abstract class EzySimpleDataHandler<S extends EzySession>
extends EzyUserDataHandler<S> {
    public EzySimpleDataHandler(EzyServerContext ctx, S session) {
        super(ctx, session);
    }

    public void dataReceived(EzyCommand cmd, EzyArray msg) {
        if (!this.active) {
            return;
        }
        if (this.isInactivatedSession()) {
            return;
        }
        this.handleReceivedData(cmd, msg);
    }

    public void streamingReceived(byte[] bytes) {
        if (!this.active) {
            return;
        }
        if (this.isInactivatedSession()) {
            return;
        }
        this.handleReceivedStreaming(bytes);
    }

    protected boolean isInactivatedSession() {
        return this.session == null || !this.session.isActivated();
    }

    public void processMaxRequestPerSecond() {
        this.responseError();
        if (this.maxRequestPerSecond.getAction() == EzyMaxRequestPerSecondAction.DISCONNECT_SESSION) {
            this.active = false;
            if (this.sessionManager != null) {
                this.sessionManager.removeSession(this.session, EzyDisconnectReason.MAX_REQUEST_PER_SECOND);
            }
        }
    }

    protected void handleReceivedStreaming(byte[] bytes) {
        this.updateSessionBeforeHandleRequest();
        this.doHandleReceivedStreaming(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doHandleReceivedStreaming(byte[] bytes) {
        try {
            EzyStreamingRequest request = this.newStreamingRequest(bytes);
            try {
                EzyInterceptor interceptor = this.controllers.getStreamingInterceptor();
                interceptor.intercept(this.context, request);
                EzyStreamingController controller = this.controllers.getStreamingController();
                controller.handle(this.zoneContext, request);
            }
            finally {
                request.release();
            }
        }
        catch (Throwable e) {
            this.context.handleException(Thread.currentThread(), e);
        }
    }

    protected void handleReceivedData(EzyConstant cmd, EzyArray msg) {
        EzyArray data = (EzyArray)msg.get(1, EzyArray.class);
        this.debugLogReceivedData(cmd, data);
        this.updateSessionBeforeHandleRequest();
        this.handleRequest(cmd, data);
    }

    private void updateSessionBeforeHandleRequest() {
        this.session.addReadRequests(1);
        this.session.setLastReadTime(System.currentTimeMillis());
        this.session.setLastActivityTime(System.currentTimeMillis());
    }

    protected void debugLogReceivedData(EzyConstant cmd, EzyArray data) {
        boolean debug = this.settings.isDebug();
        if (debug && !this.ignoredLogCommands.contains(cmd)) {
            this.logger.debug("received from: {}, command: {}, data: {}", new Object[]{this.session.getName(), cmd, data});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequest(EzyConstant cmd, EzyArray data) {
        try {
            EzyRequest request = this.newRequest(cmd, data);
            try {
                EzyInterceptor interceptor = this.controllers.getInterceptor(cmd);
                interceptor.intercept(this.context, request);
                EzyController controller = this.controllers.getController(cmd);
                controller.handle(this.context, request);
            }
            finally {
                request.release();
            }
        }
        catch (Exception e) {
            if (this.context != null) {
                EzyRequestHandleException throwable = EzyRequestHandleException.requestHandleException(this.session, cmd, data, e);
                this.context.handleException(Thread.currentThread(), throwable);
            }
            if (this.active) {
                this.logger.warn("fatal error, please add an issue to ezyfox-server github with log: {}\nand stacktrace: ", (Object)this, (Object)e);
            }
            this.logger.warn("can't handle command: {} and data: {}, this session maybe destroyed (session: {}), error message: {}", new Object[]{cmd, data, this.session, e.getMessage()});
        }
    }

    public void exceptionCaught(Throwable cause) {
        this.logger.debug("exception caught at session: {}", (Object)this.session, (Object)cause);
        EzyExceptionHandler exceptionHandler = (EzyExceptionHandler)this.exceptionHandlers.get(cause.getClass());
        if (exceptionHandler != null) {
            exceptionHandler.handleException(Thread.currentThread(), cause);
        }
    }

    public void channelInactive(EzyConstant reason) {
        this.lock.lock();
        try {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
        }
        finally {
            this.lock.unlock();
        }
        this.doChannelInactive(reason);
    }

    protected void doChannelInactive(EzyConstant reason) {
        this.removeSession();
        this.notifySessionRemoved(reason);
        this.closeSession(reason);
        this.checkToUnmapUser(reason);
        this.destroy();
    }

    protected void removeSession() {
        if (this.sessionManager != null) {
            this.sessionManager.clearSession(this.session);
        }
    }

    protected void notifySessionRemoved(EzyConstant reason) {
        if (this.zoneContext != null) {
            EzyEvent event = this.newSessionRemovedEvent(reason);
            this.notifyAppsSessionRemoved(event);
            this.notifyPluginsSessionRemoved(event);
        }
    }

    protected void notifyAppsSessionRemoved(EzyEvent event) {
        if (this.user != null) {
            this.doNotifyAppsSessionRemoved(event);
        }
    }

    protected void doNotifyAppsSessionRemoved(EzyEvent event) {
        try {
            this.zoneContext.broadcastApps((EzyConstant)EzyEventType.SESSION_REMOVED, event, this.user, true);
        }
        catch (Exception e) {
            this.logger.error("notify session: {} removed to apps error", (Object)this.session, (Object)e);
        }
    }

    protected void notifyPluginsSessionRemoved(EzyEvent event) {
        try {
            this.zoneContext.broadcastPlugins(EzyEventType.SESSION_REMOVED, event, true);
        }
        catch (Exception e) {
            this.logger.error("notify session: {} removed to apps error", (Object)this.session, (Object)e);
        }
    }

    protected void closeSession(EzyConstant reason) {
        try {
            this.closeSession.close(this.session, reason);
        }
        catch (Exception ex) {
            this.logger.error("close session: {} with reason: {} error", new Object[]{this.session, reason, ex});
        }
    }

    protected EzyEvent newSessionRemovedEvent(EzyConstant reason) {
        return new EzySimpleSessionRemovedEvent(this.user, this.session, reason);
    }
}

