/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.socket;

import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyfoxserver.entity.EzySession;
import com.tvd12.ezyfoxserver.socket.EzyRequestQueue;
import com.tvd12.ezyfoxserver.socket.EzySessionTicketsQueue;
import com.tvd12.ezyfoxserver.socket.EzySocketAbstractEventHandler;
import com.tvd12.ezyfoxserver.socket.EzySocketDataHandlerGroup;
import com.tvd12.ezyfoxserver.socket.EzySocketDataHandlerGroupFetcher;
import com.tvd12.ezyfoxserver.socket.EzySocketRequest;
import lombok.Generated;

public abstract class EzySocketRequestHandler
extends EzySocketAbstractEventHandler {
    protected EzySessionTicketsQueue sessionTicketsQueue;
    protected EzySocketDataHandlerGroupFetcher dataHandlerGroupFetcher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvent() {
        EzySocketRequest request = null;
        try {
            EzyRequestQueue requestQueue;
            Object session = this.sessionTicketsQueue.take();
            EzyRequestQueue ezyRequestQueue = requestQueue = this.getRequestQueue((EzySession)session);
            synchronized (ezyRequestQueue) {
                request = requestQueue.take();
                if (requestQueue.size() > 0) {
                    this.sessionTicketsQueue.add((EzySession)session);
                }
            }
            this.processRequest(request);
        }
        catch (InterruptedException e) {
            this.logger.info("{}-request-handler thread interrupted", (Object)this.getRequestType());
        }
        catch (Throwable throwable) {
            this.logger.warn("problems in {}-request-handler", (Object)this.getRequestType(), (Object)throwable);
        }
        finally {
            if (request != null) {
                request.release();
            }
        }
    }

    public void destroy() {
        EzyProcessor.processWithLogException(this.sessionTicketsQueue::clear);
    }

    protected abstract EzyRequestQueue getRequestQueue(EzySession var1);

    protected abstract String getRequestType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(EzySocketRequest request) throws Exception {
        try {
            EzyArray data = request.getData();
            EzySession session = request.getSession();
            EzySocketDataHandlerGroup handlerGroup = this.getDataHandlerGroup(session);
            if (handlerGroup != null) {
                handlerGroup.fireChannelRead(request.getCommand(), data);
            } else {
                this.logger.warn("has no handler group with session: {}, drop request: {}", (Object)session, (Object)request);
            }
        }
        finally {
            request.release();
        }
    }

    protected EzySocketDataHandlerGroup getDataHandlerGroup(EzySession session) {
        return this.dataHandlerGroupFetcher.getDataHandlerGroup(session);
    }

    @Generated
    public void setSessionTicketsQueue(EzySessionTicketsQueue sessionTicketsQueue) {
        this.sessionTicketsQueue = sessionTicketsQueue;
    }

    @Generated
    public void setDataHandlerGroupFetcher(EzySocketDataHandlerGroupFetcher dataHandlerGroupFetcher) {
        this.dataHandlerGroupFetcher = dataHandlerGroupFetcher;
    }
}

