/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.socket;

import com.tvd12.ezyfox.constant.EzyConstant;
import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyfoxserver.EzyApplication;
import com.tvd12.ezyfoxserver.constant.EzyEventType;
import com.tvd12.ezyfoxserver.context.EzyAppContext;
import com.tvd12.ezyfoxserver.context.EzyZoneContext;
import com.tvd12.ezyfoxserver.entity.EzyUser;
import com.tvd12.ezyfoxserver.event.EzySimpleUserRemovedEvent;
import com.tvd12.ezyfoxserver.event.EzyUserRemovedEvent;
import com.tvd12.ezyfoxserver.socket.EzySocketAbstractEventHandler;
import com.tvd12.ezyfoxserver.socket.EzySocketUserRemoval;
import com.tvd12.ezyfoxserver.socket.EzySocketUserRemovalQueue;
import com.tvd12.ezyfoxserver.wrapper.EzyAppUserManager;

public class EzySocketUserRemovalHandler
extends EzySocketAbstractEventHandler {
    protected final EzySocketUserRemovalQueue userRemovalQueue;

    public EzySocketUserRemovalHandler(EzySocketUserRemovalQueue userRemovalQueue) {
        this.userRemovalQueue = userRemovalQueue;
    }

    @Override
    public void handleEvent() {
        this.processUserRemovalQueue();
    }

    public void destroy() {
        EzyProcessor.processWithLogException(this.userRemovalQueue::clear);
    }

    private void processUserRemovalQueue() {
        try {
            EzySocketUserRemoval removal = this.userRemovalQueue.take();
            this.processUserRemoval(removal);
        }
        catch (InterruptedException e) {
            this.logger.info("user-removal-handler thread interrupted: {}", (Object)Thread.currentThread());
        }
        catch (Throwable throwable) {
            this.logger.warn("problems in user-removal-handler, thread: {}", (Object)Thread.currentThread(), (Object)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUserRemoval(EzySocketUserRemoval removal) {
        try {
            EzyUser user = removal.getUser();
            try {
                EzyConstant reason = removal.getReason();
                EzyZoneContext zoneContext = removal.getZoneContext();
                EzyUserRemovedEvent event = this.newUserRemovedEvent(user, reason);
                this.removeUserFromApps(zoneContext, event);
                this.notifyUserRemovedToPlugins(zoneContext, event);
            }
            finally {
                user.destroy();
            }
            this.logger.debug("user {} has destroyed", (Object)user);
        }
        finally {
            removal.release();
        }
    }

    protected void notifyUserRemovedToPlugins(EzyZoneContext context, EzyUserRemovedEvent event) {
        try {
            context.broadcastPlugins(EzyEventType.USER_REMOVED, event, true);
        }
        catch (Exception e) {
            String zoneName = context.getZone().getSetting().getName();
            this.logger.error("zone: {}, notify to plugins user: {} removed error", new Object[]{zoneName, event.getUser(), e});
        }
    }

    protected void removeUserFromApps(EzyZoneContext zoneContext, EzyUserRemovedEvent event) {
        for (EzyAppContext appContext : zoneContext.getAppContexts()) {
            this.removeUserFromApp(appContext, event);
        }
    }

    protected void removeUserFromApp(EzyAppContext appContext, EzyUserRemovedEvent event) {
        EzyUser user = event.getUser();
        EzyApplication app = appContext.getApp();
        EzyAppUserManager userManager = app.getUserManager();
        try {
            boolean contains = userManager.containsUser(user);
            if (contains) {
                userManager.removeUser(user, event.getReason());
            }
        }
        catch (Exception e) {
            String appName = app.getSetting().getName();
            this.logger.error("remove user: {} from app: {} error", new Object[]{event.getUser(), appName, e});
        }
    }

    protected EzyUserRemovedEvent newUserRemovedEvent(EzyUser user, EzyConstant reason) {
        return new EzySimpleUserRemovedEvent(user, reason);
    }
}

