/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.codec;

import com.tvd12.ezyfox.codec.MsgPackConstant;
import com.tvd12.ezyfox.io.EzyBytes;
import com.tvd12.ezyfox.io.EzyCastToByte;

public class MsgPackMapSizeSerializer
implements EzyCastToByte {
    private static final MsgPackMapSizeSerializer INSTANCE = new MsgPackMapSizeSerializer();

    private MsgPackMapSizeSerializer() {
    }

    public static MsgPackMapSizeSerializer getInstance() {
        return INSTANCE;
    }

    public byte[] serialize(int size) {
        if (size <= MsgPackConstant.MAX_FIXMAP_SIZE) {
            return this.parseFix(size);
        }
        if (size <= MsgPackConstant.MAX_MAP16_SIZE) {
            return this.parse16(size);
        }
        return this.parse32(size);
    }

    private byte[] parseFix(int size) {
        return new byte[]{this.cast(0x80 | size)};
    }

    private byte[] parse16(int size) {
        return EzyBytes.getBytes((int)222, (int)size, (int)2);
    }

    private byte[] parse32(int size) {
        return EzyBytes.getBytes((int)223, (int)size, (int)4);
    }
}

