/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.reflect;

import com.tvd12.ezyfox.collect.Lists;
import com.tvd12.ezyfox.reflect.EzyClasses;
import com.tvd12.ezyfox.reflect.EzyField;
import com.tvd12.ezyfox.reflect.EzyFields;
import com.tvd12.ezyfox.reflect.EzyGetterMethod;
import com.tvd12.ezyfox.reflect.EzyMethod;
import com.tvd12.ezyfox.reflect.EzyMethods;
import com.tvd12.ezyfox.reflect.EzyReflectElement;
import com.tvd12.ezyfox.reflect.EzySetterMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class EzyClass
implements EzyReflectElement {
    protected final Class clazz;
    protected final List<EzyField> fields;
    protected final List<EzyMethod> methods;
    protected final List<EzyField> declaredFields;
    protected final List<EzyMethod> declaredMethods;
    protected final Map<String, EzyField> fieldsByName;
    protected final Map<String, EzyMethod> methodsByName;

    public EzyClass(Class clazz) {
        this.clazz = clazz;
        this.methods = this.newMethods(clazz);
        this.fields = this.newFields(clazz);
        this.declaredFields = this.newDeclaredFields(clazz);
        this.declaredMethods = this.newDeclaredMethods(clazz);
        this.fieldsByName = this.mapFieldsByName();
        this.methodsByName = this.mapMethodsByName();
    }

    public <T> T newInstance() {
        return EzyClasses.newInstance(this.clazz);
    }

    @Override
    public String getName() {
        return this.clazz.getName();
    }

    public int getModifiers() {
        return this.clazz.getModifiers();
    }

    public EzyField getField(String name) {
        return this.fieldsByName.get(name);
    }

    public Optional<EzyField> getField(Predicate<EzyField> predicate) {
        return this.fields.stream().filter(predicate).findFirst();
    }

    public EzyMethod getMethod(String name) {
        return this.methodsByName.get(name);
    }

    public Optional<EzyMethod> getMethod(Predicate<EzyMethod> predicate) {
        return this.methods.stream().filter(predicate).findFirst();
    }

    @Override
    public boolean isAnnotated(Class<? extends Annotation> annClass) {
        return this.clazz.isAnnotationPresent(annClass);
    }

    public boolean isAnnotatedIncludeSuper(Class<? extends Annotation> annClass) {
        return EzyClasses.isAnnotationPresentIncludeSuper(this.clazz, annClass);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annClass) {
        return this.clazz.getAnnotation(annClass);
    }

    public List<Constructor> getDeclaredConstructors() {
        return Lists.newArrayList(this.clazz.getDeclaredConstructors());
    }

    public Constructor getDeclaredConstructor(Class ... parameterTypes) {
        try {
            return this.clazz.getDeclaredConstructor(parameterTypes);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Constructor getNoArgsDeclaredConstructor() {
        for (Constructor<?> constructor : this.clazz.getDeclaredConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            return constructor;
        }
        return null;
    }

    public Constructor getMaxArgsDeclaredConstructor() {
        Constructor<?>[] constructors = this.clazz.getDeclaredConstructors();
        Constructor<?> max = constructors[0];
        for (int i = 1; i < constructors.length; ++i) {
            if (constructors[i].getParameterCount() <= max.getParameterCount()) continue;
            max = constructors[i];
        }
        return max;
    }

    public EzyMethod getGetterMethod(String methodName) {
        Optional<EzyMethod> optional = this.getGetterMethod((EzyMethod m) -> m.getName().equals(methodName));
        return optional.orElse(null);
    }

    public Optional<EzyMethod> getGetterMethod(Predicate<EzyMethod> predicate) {
        return this.methods.stream().filter(m -> m.isGetter() && predicate.test((EzyMethod)m)).findFirst();
    }

    public EzyMethod getSetterMethod(String methodName) {
        Optional<EzyMethod> optional = this.getSetterMethod((EzyMethod m) -> m.getName().equals(methodName));
        return optional.orElse(null);
    }

    public Optional<EzyMethod> getSetterMethod(Predicate<EzyMethod> predicate) {
        return this.methods.stream().filter(m -> m.isSetter() && predicate.test((EzyMethod)m)).findFirst();
    }

    public List<EzyGetterMethod> getGetterMethods() {
        return this.getMethods(EzyMethod::isGetter, EzyGetterMethod::new);
    }

    public List<EzyGetterMethod> getGetterMethods(Predicate<EzyGetterMethod> predicate) {
        return this.getGetterMethods().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<EzySetterMethod> getSetterMethods() {
        return this.getMethods(EzyMethod::isSetter, EzySetterMethod::new);
    }

    public List<EzySetterMethod> getSetterMethods(Predicate<EzySetterMethod> predicate) {
        return this.getSetterMethods().stream().filter(predicate).collect(Collectors.toList());
    }

    public Optional<EzyMethod> getAnnotatedGetterMethod(Class<? extends Annotation> annClass) {
        return this.getGetterMethod((EzyMethod m) -> m.isAnnotated(annClass));
    }

    public Optional<EzyMethod> getAnnotatedSetterMethod(Class<? extends Annotation> annClass) {
        return this.getSetterMethod((EzyMethod m) -> m.isAnnotated(annClass));
    }

    public Optional<EzyMethod> getPublicMethod(Predicate<EzyMethod> predicate) {
        return this.methods.stream().filter(m -> m.isPublic() && predicate.test((EzyMethod)m)).findFirst();
    }

    public List<EzyMethod> getPublicMethods() {
        return this.getMethods(EzyMethod::isPublic);
    }

    public List<EzyMethod> getPublicMethods(Predicate<EzyMethod> predicate) {
        return this.getMethods(m -> m.isPublic() && predicate.test((EzyMethod)m));
    }

    public List<EzyMethod> getMethods(Predicate<EzyMethod> predicate) {
        return this.methods.stream().filter(predicate).distinct().collect(Collectors.toList());
    }

    public <T extends EzyMethod> List<T> getMethods(Predicate<EzyMethod> predicate, Function<EzyMethod, T> creator) {
        return this.methods.stream().filter(predicate).flatMap(m -> Stream.of(creator.apply((EzyMethod)m))).distinct().collect(Collectors.toList());
    }

    public List<EzyMethod> getDistinctMethods(Predicate<EzyMethod> predicate) {
        List<EzyMethod> allMethods = this.getMethods(predicate);
        return EzyMethods.filterOverriddenMethods(allMethods);
    }

    public List<EzyField> getWritableFields() {
        return this.getFields(EzyField::isWritable);
    }

    public List<EzyField> getPublicFields() {
        return this.getFields(EzyField::isPublic);
    }

    public List<EzyField> getPublicFields(Predicate<EzyField> predicate) {
        return this.getFields(f -> f.isPublic() && predicate.test((EzyField)f));
    }

    public List<EzyField> getFields(Predicate<EzyField> predicate) {
        return this.fields.stream().filter(predicate).distinct().collect(Collectors.toList());
    }

    public List<EzySetterMethod> getDeclaredSetterMethods() {
        return this.getDeclaredMethods(EzyMethod::isSetter, EzySetterMethod::new);
    }

    public List<EzyGetterMethod> getDeclaredGetterMethods() {
        return this.getDeclaredMethods(EzyMethod::isGetter, EzyGetterMethod::new);
    }

    public <T extends EzyMethod> List<T> getDeclaredMethods(Predicate<EzyMethod> predicate, Function<EzyMethod, T> creator) {
        return this.declaredMethods.stream().filter(predicate).flatMap(m -> Stream.of(creator.apply((EzyMethod)m))).distinct().collect(Collectors.toList());
    }

    public List<EzyMethod> getDeclaredMethods(Predicate<EzyMethod> predicate) {
        return this.declaredMethods.stream().filter(predicate).distinct().collect(Collectors.toList());
    }

    public Optional<EzyField> getAnnotatedField(Class<? extends Annotation> annClass) {
        return this.getField((EzyField m) -> m.isAnnotated(annClass));
    }

    public List<EzyField> getAnnotatedFields(Class<? extends Annotation> annClass) {
        return this.getFields(m -> m.isAnnotated(annClass));
    }

    public Optional<EzyMethod> getAnnotatedMethod(Class<? extends Annotation> annClass) {
        return this.getMethod((EzyMethod m) -> m.isAnnotated(annClass));
    }

    public List<EzyMethod> getAnnotatedMethods(Class<? extends Annotation> annClass) {
        return this.getMethods(m -> m.isAnnotated(annClass));
    }

    private List<EzyField> newFields(Class clazz) {
        ArrayList<EzyField> answer = new ArrayList<EzyField>();
        EzyFields.getFields(clazz).forEach(f -> answer.add(new EzyField((Field)f)));
        return answer;
    }

    private List<EzyMethod> newMethods(Class clazz) {
        ArrayList<EzyMethod> answer = new ArrayList<EzyMethod>();
        EzyMethods.getMethods(clazz).forEach(m -> answer.add(new EzyMethod((Method)m)));
        return answer;
    }

    private List<EzyField> newDeclaredFields(Class clazz) {
        ArrayList<EzyField> answer = new ArrayList<EzyField>();
        EzyFields.getDeclaredFields(clazz).forEach(f -> answer.add(new EzyField((Field)f)));
        return answer;
    }

    private List<EzyMethod> newDeclaredMethods(Class clazz) {
        ArrayList<EzyMethod> answer = new ArrayList<EzyMethod>();
        EzyMethods.getDeclaredMethods(clazz).forEach(m -> answer.add(new EzyMethod((Method)m)));
        return answer;
    }

    private Map<String, EzyField> mapFieldsByName() {
        HashMap<String, EzyField> map = new HashMap<String, EzyField>();
        this.fields.forEach(f -> map.put(f.getName(), (EzyField)f));
        return map;
    }

    private Map<String, EzyMethod> mapMethodsByName() {
        HashMap<String, EzyMethod> map = new HashMap<String, EzyMethod>();
        this.methods.forEach(m -> map.put(m.getName(), (EzyMethod)m));
        return map;
    }

    public String toString() {
        return this.clazz.toString();
    }

    @Generated
    public Class getClazz() {
        return this.clazz;
    }

    @Generated
    public List<EzyField> getFields() {
        return this.fields;
    }

    @Generated
    public List<EzyMethod> getMethods() {
        return this.methods;
    }

    @Generated
    public List<EzyField> getDeclaredFields() {
        return this.declaredFields;
    }

    @Generated
    public List<EzyMethod> getDeclaredMethods() {
        return this.declaredMethods;
    }

    @Generated
    public Map<String, EzyField> getFieldsByName() {
        return this.fieldsByName;
    }

    @Generated
    public Map<String, EzyMethod> getMethodsByName() {
        return this.methodsByName;
    }
}

