/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.handler;

import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyhttp.core.codec.BodyDeserializer;
import com.tvd12.ezyhttp.core.codec.DataConverters;
import com.tvd12.ezyhttp.core.codec.StringDeserializer;
import com.tvd12.ezyhttp.core.data.BodyData;
import com.tvd12.ezyhttp.core.exception.DeserializeBodyException;
import com.tvd12.ezyhttp.core.exception.DeserializeCookieException;
import com.tvd12.ezyhttp.core.exception.DeserializeHeaderException;
import com.tvd12.ezyhttp.core.exception.DeserializeParameterException;
import com.tvd12.ezyhttp.core.exception.DeserializePathVariableException;
import com.tvd12.ezyhttp.core.exception.HttpBadRequestException;
import com.tvd12.ezyhttp.server.core.handler.RequestHandler;
import com.tvd12.ezyhttp.server.core.manager.ComponentManager;
import com.tvd12.ezyhttp.server.core.request.RequestArguments;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.servlet.AsyncContext;
import lombok.Generated;

public abstract class AbstractRequestHandler
implements RequestHandler {
    protected Method handlerMethod;
    protected final DataConverters dataConverters;
    protected final ComponentManager componentManager = ComponentManager.getInstance();

    public AbstractRequestHandler() {
        this.dataConverters = this.componentManager.getDataConverters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object handle(RequestArguments arguments) throws Exception {
        try {
            return this.handleRequest(arguments);
        }
        catch (Exception e) {
            try {
                Object object = this.handleException(arguments, e);
                return object;
            }
            finally {
                if (arguments.isAsyncStarted()) {
                    AsyncContext asyncContext = arguments.getAsyncContext();
                    EzyProcessor.processWithLogException(() -> ((AsyncContext)asyncContext).complete());
                }
            }
        }
    }

    protected abstract Object handleRequest(RequestArguments var1) throws Exception;

    protected abstract Object handleException(RequestArguments var1, Exception var2) throws Exception;

    protected <T> T deserializeHeader(int index, String value, Class<T> type, Class<?> genericType) throws IOException {
        try {
            StringDeserializer deserializer = this.dataConverters.getStringDeserializer();
            return (T)deserializer.deserialize(value, type, genericType);
        }
        catch (Exception e) {
            throw new DeserializeHeaderException("header#" + index, (Object)value, type, e);
        }
    }

    protected <T> T deserializeHeader(String name, String value, Class<T> type, Class<?> genericType) throws IOException {
        try {
            StringDeserializer deserializer = this.dataConverters.getStringDeserializer();
            return (T)deserializer.deserialize(value, type, genericType);
        }
        catch (Exception e) {
            throw new DeserializeHeaderException(name, (Object)value, type, e);
        }
    }

    protected <T> T deserializeParameter(int index, String value, Class<T> type, Class<?> genericType) throws IOException {
        try {
            StringDeserializer deserializer = this.dataConverters.getStringDeserializer();
            return (T)deserializer.deserialize(value, type, genericType);
        }
        catch (Exception e) {
            throw new DeserializeParameterException("parameter#" + index, (Object)value, type, e);
        }
    }

    protected <T> T deserializeParameter(String name, String value, Class<T> type, Class<?> genericType) throws IOException {
        try {
            StringDeserializer deserializer = this.dataConverters.getStringDeserializer();
            return (T)deserializer.deserialize(value, type, genericType);
        }
        catch (Exception e) {
            throw new DeserializeParameterException(name, (Object)value, type, e);
        }
    }

    protected <T> T deserializePathVariable(String name, String value, Class<T> type, Class<?> genericType) throws IOException {
        try {
            StringDeserializer deserializer = this.dataConverters.getStringDeserializer();
            return (T)deserializer.deserialize(value, type, genericType);
        }
        catch (Exception e) {
            throw new DeserializePathVariableException(name, (Object)value, type, e);
        }
    }

    protected <T> T deserializePathVariable(int index, String value, Class<T> type, Class<?> genericType) throws IOException {
        try {
            StringDeserializer deserializer = this.dataConverters.getStringDeserializer();
            return (T)deserializer.deserialize(value, type, genericType);
        }
        catch (Exception e) {
            throw new DeserializePathVariableException("pathVariable#" + index, (Object)value, type, e);
        }
    }

    protected <T> T deserializeCookie(int index, String value, Class<T> type, Class<?> genericType) throws IOException {
        try {
            StringDeserializer deserializer = this.dataConverters.getStringDeserializer();
            return (T)deserializer.deserialize(value, type, genericType);
        }
        catch (Exception e) {
            throw new DeserializeCookieException("cookie#" + index, (Object)value, type, e);
        }
    }

    protected <T> T deserializeCookie(String name, String value, Class<T> type, Class<?> genericType) throws IOException {
        try {
            StringDeserializer deserializer = this.dataConverters.getStringDeserializer();
            return (T)deserializer.deserialize(value, type, genericType);
        }
        catch (Exception e) {
            throw new DeserializeCookieException(name, (Object)value, type, e);
        }
    }

    protected <T> T deserializeBody(BodyData bodyData, Class<T> type) throws IOException {
        String contentType = bodyData.getContentType();
        if (contentType == null) {
            throw new HttpBadRequestException((Object)"contentType is null");
        }
        BodyDeserializer deserializer = this.dataConverters.getBodyDeserializer(contentType);
        try {
            return (T)deserializer.deserialize(bodyData, type);
        }
        catch (Exception e) {
            throw new DeserializeBodyException("can't deserialize body data to: " + type.getName(), e);
        }
    }

    @Override
    @Generated
    public void setHandlerMethod(Method handlerMethod) {
        this.handlerMethod = handlerMethod;
    }

    @Override
    @Generated
    public Method getHandlerMethod() {
        return this.handlerMethod;
    }
}

