/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.io.EzyStrings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.entity.AccessTokenMeta;
import org.youngmonkeys.ezyplatform.entity.AccessTokenStatus;
import org.youngmonkeys.ezyplatform.entity.AdminActivityHistory;
import org.youngmonkeys.ezyplatform.entity.ContentTemplate;
import org.youngmonkeys.ezyplatform.entity.DataI18n;
import org.youngmonkeys.ezyplatform.entity.DataIndex;
import org.youngmonkeys.ezyplatform.entity.DataMapping;
import org.youngmonkeys.ezyplatform.entity.DataRecordCount;
import org.youngmonkeys.ezyplatform.entity.DataType;
import org.youngmonkeys.ezyplatform.entity.Letter;
import org.youngmonkeys.ezyplatform.entity.LetterReceiver;
import org.youngmonkeys.ezyplatform.entity.Link;
import org.youngmonkeys.ezyplatform.entity.Media;
import org.youngmonkeys.ezyplatform.entity.Notification;
import org.youngmonkeys.ezyplatform.entity.NotificationReceiver;
import org.youngmonkeys.ezyplatform.entity.Setting;
import org.youngmonkeys.ezyplatform.entity.UniqueData;
import org.youngmonkeys.ezyplatform.entity.UploadFrom;
import org.youngmonkeys.ezyplatform.entity.UserAccessToken;
import org.youngmonkeys.ezyplatform.entity.UserKeyword;
import org.youngmonkeys.ezyplatform.model.AddAdminActivityHistoryModel;
import org.youngmonkeys.ezyplatform.model.AddLetterModel;
import org.youngmonkeys.ezyplatform.model.AddLetterReceiverModel;
import org.youngmonkeys.ezyplatform.model.AddMediaModel;
import org.youngmonkeys.ezyplatform.model.AddNotificationModel;
import org.youngmonkeys.ezyplatform.model.AddNotificationReceiverModel;
import org.youngmonkeys.ezyplatform.model.AddUserKeywordModel;
import org.youngmonkeys.ezyplatform.model.DataI18nModel;
import org.youngmonkeys.ezyplatform.model.SaveAccessTokenMetaModel;
import org.youngmonkeys.ezyplatform.model.SaveContentTemplateModel;
import org.youngmonkeys.ezyplatform.model.SaveDataKeywordModel;
import org.youngmonkeys.ezyplatform.model.SaveDataMappingModel;
import org.youngmonkeys.ezyplatform.model.SaveLinkModel;
import org.youngmonkeys.ezyplatform.model.UniqueDataKeyValueModel;
import org.youngmonkeys.ezyplatform.model.UniqueDataModel;
import org.youngmonkeys.ezyplatform.model.UpdateMediaModel;
import org.youngmonkeys.ezyplatform.time.ClockProxy;
import org.youngmonkeys.ezyplatform.util.Strings;

public class DefaultModelToEntityConverter {
    protected final ClockProxy clock;
    protected final ObjectMapper objectMapper;

    public Media toEntity(AddMediaModel model) {
        return this.toEntity(model, UploadFrom.ADMIN);
    }

    public Media toEntity(AddMediaModel model, UploadFrom uploadFrom) {
        LocalDateTime now = this.clock.nowDateTime();
        Media entity = new Media();
        if (uploadFrom == UploadFrom.ADMIN) {
            entity.setOwnerAdminId(model.getOwnerId());
        } else {
            entity.setOwnerUserId(model.getOwnerId());
        }
        entity.setUploadFrom(uploadFrom);
        entity.setName(model.getFileName());
        entity.setUrl(model.getUrl());
        entity.setOriginalName(model.getOriginalFileName());
        entity.setType(model.getMediaType());
        entity.setMimeType(model.getMimeType());
        entity.setAlternativeText("");
        entity.setCaption("");
        entity.setDescription("");
        entity.setPublicMedia(!model.isNotPublic());
        entity.setCreatedAt(now);
        entity.setUpdatedAt(now);
        return entity;
    }

    public Letter toEntity(AddLetterModel model) {
        Letter letter = new Letter();
        letter.setTitle(model.getTitle());
        letter.setContent(model.getContent());
        letter.setContentType(model.getContentType());
        letter.setType(model.getType());
        letter.setFromAdminId(model.getFromAdminId());
        letter.setFromUserId(model.getFromUserId());
        letter.setParentId(model.getParentId());
        letter.setStatus(model.getLetterStatus());
        letter.setCreatedAt(this.clock.nowDateTime());
        return letter;
    }

    public Notification toEntity(AddNotificationModel model) {
        Notification notification = new Notification();
        notification.setTitle(model.getTitle());
        notification.setContent(model.getContent());
        notification.setContentType(model.getContentType());
        notification.setIconImage(model.getIconImage());
        notification.setType(model.getType());
        notification.setFromAdminId(model.getFromAdminId());
        notification.setFromUserId(model.getFromUserId());
        notification.setDeepLink(model.getDeepLink());
        notification.setStatus(model.getNotificationStatus());
        notification.setCreatedAt(this.clock.nowDateTime());
        return notification;
    }

    public LetterReceiver toEntity(AddLetterReceiverModel model) {
        LetterReceiver entity = new LetterReceiver();
        entity.setLetterId(model.getLetterId());
        entity.setToUserId(model.getToUserId());
        entity.setToAdminId(model.getToAdminId());
        entity.setStatus(model.getStatus());
        entity.setConfidenceLevel(model.getConfidenceLevel());
        entity.setImportantLevel(model.getImportantLevel());
        entity.setNotificationReceiverId(model.getNotificationReceiverId());
        entity.setSentAt(this.clock.nowDateTime());
        return entity;
    }

    public LetterReceiver toEntity(long letterId, AddLetterModel model, LocalDateTime now) {
        LetterReceiver entity = new LetterReceiver();
        entity.setLetterId(letterId);
        entity.setStatus(model.getSendStatus());
        entity.setConfidenceLevel(model.getConfidenceLevel());
        entity.setImportantLevel(model.getImportantLevel());
        entity.setNotificationReceiverId(model.getNotificationReceiverId());
        entity.setSentAt(now);
        return entity;
    }

    public NotificationReceiver toEntity(AddNotificationReceiverModel model) {
        NotificationReceiver entity = new NotificationReceiver();
        entity.setNotificationId(model.getNotificationId());
        entity.setToUserId(model.getToUserId());
        entity.setToAdminId(model.getToAdminId());
        entity.setStatus(model.getStatus());
        entity.setConfidenceLevel(model.getConfidenceLevel());
        entity.setImportantLevel(model.getImportantLevel());
        entity.setSentAt(this.clock.nowDateTime());
        return entity;
    }

    public NotificationReceiver toEntity(long notificationId, AddNotificationModel model, LocalDateTime now) {
        NotificationReceiver entity = new NotificationReceiver();
        entity.setNotificationId(notificationId);
        entity.setStatus(model.getSendStatus());
        entity.setConfidenceLevel(model.getConfidenceLevel());
        entity.setImportantLevel(model.getImportantLevel());
        entity.setSentAt(now);
        return entity;
    }

    public UserKeyword toEntity(AddUserKeywordModel model) {
        UserKeyword entity = new UserKeyword();
        entity.setUserId(model.getUserId());
        entity.setKeyword(model.getKeyword());
        entity.setPriority(model.getPriority());
        entity.setCreatedAt(this.clock.nowDateTime());
        return entity;
    }

    public AdminActivityHistory toEntity(AddAdminActivityHistoryModel model) {
        String parameters = this.valueToJsonOrNull(model.getParameters());
        if (parameters != null && parameters.length() > 600) {
            parameters = parameters.substring(0, 600);
        }
        AdminActivityHistory entity = new AdminActivityHistory();
        entity.setAdminId(model.getAdminId());
        entity.setFeature(model.getFeature());
        entity.setMethod(model.getMethod());
        entity.setUri(model.getUri());
        entity.setUriType(model.getUriType());
        entity.setParameters(parameters);
        entity.setCreatedAt(this.clock.nowDateTime());
        return entity;
    }

    public Link toEntity(SaveLinkModel model) {
        Link entity = new Link();
        this.mergeToEntity(model, entity);
        entity.setCreatedAt(entity.getUpdatedAt());
        return entity;
    }

    public DataIndex toEntity(String dataType, SaveDataKeywordModel model) {
        DataIndex entity = new DataIndex();
        this.mergeToEntity(dataType, model, entity);
        entity.setCreatedAt(entity.getUpdatedAt());
        return entity;
    }

    public DataI18n toEntity(DataI18nModel model) {
        DataI18n entity = new DataI18n();
        entity.setDataType(model.getDataType());
        entity.setDataId(model.getDataId());
        entity.setLanguage(model.getLanguage());
        entity.setFieldName(model.getFieldName());
        entity.setFieldValue(model.getFieldValue());
        return entity;
    }

    public DataMapping toEntity(SaveDataMappingModel model) {
        DataMapping entity = new DataMapping();
        entity.setMappingName(model.getMappingName());
        entity.setFromDataId(model.getFromDataId());
        entity.setToDataId(model.getToDataId());
        entity.setDisplayOrder(model.getDisplayOrder());
        BigInteger quantity = model.getQuantity();
        if (quantity == null) {
            quantity = BigInteger.ZERO;
        }
        entity.setQuantity(quantity);
        BigInteger remainingQuantity = model.getRemainingQuantity();
        if (remainingQuantity == null) {
            remainingQuantity = BigInteger.ZERO;
        }
        entity.setRemainingQuantity(remainingQuantity);
        BigInteger numberData = model.getNumberData();
        if (numberData == null) {
            numberData = BigInteger.ZERO;
        }
        entity.setNumberData(numberData);
        BigDecimal decimalData = model.getDecimalData();
        if (decimalData == null) {
            decimalData = BigDecimal.ZERO;
        }
        entity.setDecimalData(decimalData);
        entity.setTextData(model.getTextData());
        entity.setMetadata(model.getMetadata());
        entity.setMappedAt(this.clock.nowDateTime());
        return entity;
    }

    public UniqueData toEntity(UniqueDataModel model) {
        UniqueData entity = new UniqueData();
        entity.setDataType(model.getDataType());
        entity.setDataId(model.getDataId());
        entity.setUniqueKey(model.getUniqueKey());
        String textValue = model.getTextValue();
        entity.setTextValue(textValue);
        BigInteger numberValue = model.getNumberValue();
        if (numberValue == null) {
            numberValue = Strings.toBigIntegerOrZero(textValue);
        }
        entity.setNumberValue(numberValue);
        BigDecimal decimalValue = model.getDecimalValue();
        if (decimalValue == null) {
            decimalValue = Strings.toBigDecimalOrZero(textValue);
        }
        entity.setDecimalValue(decimalValue);
        entity.setMetadata(model.getMetadata());
        return entity;
    }

    public UniqueData toEntity(String dataType, long dataId, UniqueDataKeyValueModel model) {
        UniqueData entity = new UniqueData();
        entity.setDataType(dataType);
        entity.setDataId(dataId);
        entity.setUniqueKey(model.getUniqueKey());
        String textValue = model.getTextValue();
        entity.setTextValue(textValue);
        BigInteger numberValue = model.getNumberValue();
        if (numberValue == null) {
            numberValue = Strings.toBigIntegerOrZero(textValue);
        }
        entity.setNumberValue(numberValue);
        BigDecimal decimalValue = model.getDecimalValue();
        if (decimalValue == null) {
            decimalValue = Strings.toBigDecimalOrZero(textValue);
        }
        entity.setDecimalValue(decimalValue);
        entity.setMetadata(model.getMetadata());
        return entity;
    }

    public ContentTemplate toEntity(String creatorType, long creatorId, SaveContentTemplateModel model) {
        ContentTemplate entity = new ContentTemplate();
        entity.setCreatorType(creatorType);
        entity.setCreatorId(creatorId);
        this.mergeToEntity(model, entity);
        entity.setCreatedAt(entity.getUpdatedAt());
        return entity;
    }

    public AccessTokenMeta toEntity(SaveAccessTokenMetaModel model) {
        AccessTokenMeta entity = new AccessTokenMeta();
        entity.setTarget(model.getTarget());
        entity.setAccessToken(model.getAccessToken());
        this.mergeToEntity(model, entity);
        return entity;
    }

    public UserAccessToken toUserAccessTokenEntity(long userId, String token, long tokenExpiredTimeInDay, AccessTokenStatus status) {
        LocalDateTime now = this.clock.nowDateTime();
        LocalDateTime expiredAt = now.plusDays(tokenExpiredTimeInDay);
        return this.toUserAccessTokenEntity(userId, token, status, now, expiredAt);
    }

    public UserAccessToken toUserAccessTokenEntity(long userId, String token, long tokenExpiredTime, TimeUnit tokenExpiredTimeUnit, AccessTokenStatus status) {
        LocalDateTime now = this.clock.nowDateTime();
        LocalDateTime expiredAt = now.plusSeconds(tokenExpiredTimeUnit.toSeconds(tokenExpiredTime));
        return this.toUserAccessTokenEntity(userId, token, status, now, expiredAt);
    }

    public UserAccessToken toUserAccessTokenEntity(long userId, String token, AccessTokenStatus status, LocalDateTime now, LocalDateTime expiredAt) {
        UserAccessToken userAccessToken = new UserAccessToken();
        userAccessToken.setId(token);
        userAccessToken.setUserId(userId);
        userAccessToken.setStatus(status);
        userAccessToken.setCreatedAt(now);
        userAccessToken.setExpiredAt(expiredAt);
        return userAccessToken;
    }

    public Setting toSettingEntity(String name, DataType dataType, Object value) {
        Setting entity = new Setting();
        this.mergeToSettingEntity(name, dataType, value, entity);
        entity.setCreatedAt(entity.getUpdatedAt());
        return entity;
    }

    public DataRecordCount toNewDataRecordCount(String dataType) {
        DataRecordCount entity = new DataRecordCount();
        entity.setDataType(dataType);
        entity.setLastCountedAt(this.clock.nowDateTime());
        return entity;
    }

    public List<NotificationReceiver> toEntities(long notificationId, AddNotificationModel model) {
        NotificationReceiver entity;
        LocalDateTime now = this.clock.nowDateTime();
        ArrayList<NotificationReceiver> entities = new ArrayList<NotificationReceiver>();
        for (long toAdminId : model.getToAdminIds()) {
            if (toAdminId <= 0L) continue;
            entity = this.toEntity(notificationId, model, now);
            entity.setToAdminId(toAdminId);
            entities.add(entity);
        }
        for (long toUserId : model.getToUserIds()) {
            if (toUserId <= 0L) continue;
            entity = this.toEntity(notificationId, model, now);
            entity.setToUserId(toUserId);
            entities.add(entity);
        }
        return entities;
    }

    public List<LetterReceiver> toEntities(long letterId, AddLetterModel model) {
        LetterReceiver entity;
        LocalDateTime now = this.clock.nowDateTime();
        ArrayList<LetterReceiver> entities = new ArrayList<LetterReceiver>();
        for (long toAdminId : model.getToAdminIds()) {
            if (toAdminId <= 0L) continue;
            entity = this.toEntity(letterId, model, now);
            entity.setToAdminId(toAdminId);
            entities.add(entity);
        }
        for (long toUserId : model.getToUserIds()) {
            if (toUserId <= 0L) continue;
            entity = this.toEntity(letterId, model, now);
            entity.setToUserId(toUserId);
            entities.add(entity);
        }
        return entities;
    }

    public List<DataMapping> toEntities(String mappingName, Collection<Long> fromDataIds, Long toDataId) {
        return EzyLists.newArrayList(fromDataIds, fromDataId -> this.toEntity(SaveDataMappingModel.builder().mappingName(mappingName).fromDataId((long)fromDataId).toDataId(toDataId).build()));
    }

    public List<DataMapping> toEntities(String mappingName, Long fromDataId, Collection<Long> toDataIds) {
        return EzyLists.newArrayList(toDataIds, toDataId -> this.toEntity(SaveDataMappingModel.builder().mappingName(mappingName).fromDataId(fromDataId).toDataId((long)toDataId).build()));
    }

    public List<DataMapping> toEntities(String mappingName, Map<Long, Long> toDataIdByFromDataId) {
        return EzyLists.newArrayList(toDataIdByFromDataId.entrySet(), e -> this.toEntity(SaveDataMappingModel.builder().mappingName(mappingName).fromDataId((Long)e.getKey()).toDataId((Long)e.getValue()).build()));
    }

    public void mergeToEntity(UpdateMediaModel model, Media entity) {
        if (model.isUpdateType()) {
            entity.setType(model.getType());
        }
        entity.setAlternativeText(model.getAlternativeText());
        entity.setTitle(model.getTitle());
        entity.setCaption(model.getCaption());
        entity.setDescription(model.getDescription());
        entity.setPublicMedia(!model.isNotPublic());
        if (model.isUpdateUrl()) {
            entity.setUrl(model.getUrl());
        }
        entity.setUpdatedAt(this.clock.nowDateTime());
    }

    public void mergeToEntity(SaveLinkModel model, Link entity) {
        String sourceType = model.getSourceType();
        if (EzyStrings.isBlank((String)sourceType)) {
            sourceType = "UNKNOWN";
        }
        entity.setLinkUri(model.getLinkUri());
        entity.setLinkType(model.getLinkType());
        entity.setImageId(model.getLinkImageId());
        entity.setDescription(model.getDescription());
        entity.setSourceType(sourceType);
        entity.setSourceId(model.getSourceId());
        entity.setUpdatedAt(this.clock.nowDateTime());
    }

    public void mergeToEntity(String dataType, SaveDataKeywordModel model, DataIndex entity) {
        entity.setDataType(dataType);
        entity.setDataId(model.getDataId());
        entity.setKeyword(model.getKeyword());
        entity.setPriority(model.getPriority());
        entity.setUpdatedAt(this.clock.nowDateTime());
    }

    public void mergeToEntity(SaveContentTemplateModel model, ContentTemplate entity) {
        String templateName = model.getTemplateName();
        if (EzyStrings.isBlank((String)templateName)) {
            templateName = UUID.randomUUID().toString();
        }
        entity.setOwnerType(model.getOwnerType());
        entity.setOwnerId(model.getOwnerId());
        entity.setTemplateType(model.getTemplateType());
        entity.setTemplateName(templateName);
        entity.setTitleTemplate(model.getTitleTemplate());
        entity.setContentTemplate(model.getContentTemplate());
        String contentType = model.getContentType();
        if (contentType != null) {
            entity.setContentType(contentType);
        }
        entity.setStatus(model.getStatus());
        entity.setUpdatedAt(this.clock.nowDateTime());
    }

    public void mergeToEntity(SaveAccessTokenMetaModel model, AccessTokenMeta entity) {
        entity.setAccessTokenFull(model.getAccessTokenFull());
        entity.setParentId(model.getParentId());
        entity.setTokenType(model.getTokenType());
        entity.setAlgorithm(model.getAlgorithm());
        entity.setScope(model.getScope());
        entity.setIssuer(model.getIssuer());
        entity.setTenantId(model.getTenantId());
        entity.setClientId(model.getClientId());
        entity.setDeviceId(model.getDeviceId());
        entity.setClientSecret(model.getClientSecret());
        entity.setGrantType(model.getGrantType());
        entity.setKid(model.getKid());
        entity.setJwksUri(model.getJwksUri());
        entity.setPublicKey(model.getPublicKey());
        entity.setPrivateKey(model.getPrivateKey());
        entity.setAudience(model.getAudience());
        entity.setNotBefore(this.clock.toLocalDateTimeOrNull(model.getNotBefore()));
        entity.setUpdatedAt(this.clock.nowDateTime());
    }

    public void mergeToSettingEntity(String name, DataType dataType, Object value, Setting entity) {
        String valueString = "";
        if (value != null) {
            valueString = dataType == DataType.JSON ? this.valueToJson(value) : String.valueOf(value);
        }
        entity.setName(name);
        entity.setDataType(dataType);
        entity.setValue(valueString);
        entity.setUpdatedAt(this.clock.nowDateTime());
    }

    protected String valueToJsonOrEmpty(Object value) {
        String answer = this.valueToJsonOrNull(value);
        return answer != null ? answer : "";
    }

    protected String valueToJsonOrNull(Object value) {
        return this.valueToJson(value, false);
    }

    protected String valueToJson(Object value) {
        return this.valueToJson(value, true);
    }

    private String valueToJson(Object value, boolean throwException) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        try {
            return this.objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            if (throwException) {
                throw new IllegalArgumentException("can not convert value to json", e);
            }
            return null;
        }
    }

    @Generated
    public DefaultModelToEntityConverter(ClockProxy clock, ObjectMapper objectMapper) {
        this.clock = clock;
        this.objectMapper = objectMapper;
    }
}

