/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.service;

import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.util.Next;
import com.tvd12.ezyhttp.server.core.annotation.Service;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.youngmonkeys.ezyplatform.converter.DefaultEntityToModelConverter;
import org.youngmonkeys.ezyplatform.converter.DefaultModelToEntityConverter;
import org.youngmonkeys.ezyplatform.entity.Notification;
import org.youngmonkeys.ezyplatform.entity.NotificationReceiver;
import org.youngmonkeys.ezyplatform.entity.NotificationStatus;
import org.youngmonkeys.ezyplatform.exception.ResourceNotFoundException;
import org.youngmonkeys.ezyplatform.model.NotificationModel;
import org.youngmonkeys.ezyplatform.repo.NotificationReceiverRepository;
import org.youngmonkeys.ezyplatform.repo.NotificationRepository;
import org.youngmonkeys.ezyplatform.rx.Reactive;
import org.youngmonkeys.ezyplatform.service.DefaultNotificationService;
import org.youngmonkeys.ezyplatform.time.ClockProxy;
import org.youngmonkeys.ezyplatform.web.converter.WebEntityToModelConverter;
import org.youngmonkeys.ezyplatform.web.converter.WebModelToEntityConverter;
import org.youngmonkeys.ezyplatform.web.repo.WebNotificationReceiverRepository;
import org.youngmonkeys.ezyplatform.web.repo.WebNotificationRepository;

@Service
public class WebNotificationService
extends DefaultNotificationService {
    private final ClockProxy clock;
    private final WebNotificationRepository notificationRepository;
    private final WebNotificationReceiverRepository notificationReceiverRepository;
    private final WebEntityToModelConverter entityToModelConverter;

    public WebNotificationService(ClockProxy clock, WebNotificationRepository notificationRepository, WebNotificationReceiverRepository notificationReceiverRepository, WebEntityToModelConverter entityToModelConverter, WebModelToEntityConverter modelToEntityConverter) {
        super((NotificationRepository)notificationRepository, (NotificationReceiverRepository)notificationReceiverRepository, (DefaultEntityToModelConverter)entityToModelConverter, (DefaultModelToEntityConverter)modelToEntityConverter);
        this.clock = clock;
        this.notificationRepository = notificationRepository;
        this.notificationReceiverRepository = notificationReceiverRepository;
        this.entityToModelConverter = entityToModelConverter;
    }

    public void updateUserNotificationByReceive(long userId, long notificationId) {
        this.updateUserNotificationByReceive(userId, notificationId, true);
    }

    public void updateUserNotificationByReceive(long userId, long notificationId, boolean throwExceptionIfNotExists) {
        NotificationReceiver notificationReceiver = this.notificationReceiverRepository.findByNotificationIdAndToUserId(notificationId, userId);
        if (notificationReceiver == null) {
            if (throwExceptionIfNotExists) {
                throw new ResourceNotFoundException("notification");
            }
            return;
        }
        if (notificationReceiver.getReceivedAt() == null) {
            notificationReceiver.setReceivedAt(this.clock.nowDateTime());
            notificationReceiver.setStatus(NotificationStatus.RECEIVED.toString());
            this.notificationReceiverRepository.save(notificationReceiver);
        }
    }

    public void updateUserNotificationsByReceive(long userId, Collection<Long> notificationIds) {
        Reactive.multiple().registerConsumers(notificationIds, it -> this.updateUserNotificationByRead(userId, (long)it, false)).blockingExecute();
    }

    public void updateUserNotificationByRead(long userId, long notificationId) {
        this.updateUserNotificationByRead(userId, notificationId, true);
    }

    public void updateUserNotificationByRead(long userId, long notificationId, boolean throwExceptionIfNotExists) {
        NotificationReceiver notificationReceiver = this.notificationReceiverRepository.findByNotificationIdAndToUserId(notificationId, userId);
        if (notificationReceiver == null) {
            if (throwExceptionIfNotExists) {
                throw new ResourceNotFoundException("notification");
            }
            return;
        }
        this.doUpdateNotificationByRead(notificationReceiver);
    }

    public void updateUserNotificationsByRead(long userId, Collection<Long> notificationIds) {
        Reactive.multiple().registerConsumers(notificationIds, it -> this.updateUserNotificationByRead(userId, (long)it, false)).blockingExecute();
    }

    public void updateAllUserNotificationsByRead(long userId) {
        long limit = 100L;
        long notificationIdExclusive = Long.MAX_VALUE;
        while (true) {
            List<NotificationReceiver> entities = this.notificationReceiverRepository.findUnreadNotificationsByToUserId(userId, notificationIdExclusive, Next.limit((long)limit));
            Reactive.multiple().registerConsumers(entities, this::doUpdateNotificationByRead).blockingExecute();
            if ((long)entities.size() < limit) break;
            notificationIdExclusive = ((NotificationReceiver)EzyLists.last(entities)).getNotificationId();
        }
    }

    public void deleteUserNotification(long userId, long notificationId) {
        this.deleteUserNotification(userId, notificationId, true);
    }

    public void deleteUserNotification(long userId, long notificationId, boolean throwExceptionIfNotExists) {
        NotificationReceiver notificationReceiver = this.notificationReceiverRepository.findByNotificationIdAndToUserId(notificationId, userId);
        if (notificationReceiver == null) {
            if (throwExceptionIfNotExists) {
                throw new ResourceNotFoundException("notification");
            }
            return;
        }
        this.notificationReceiverRepository.delete(notificationReceiver.getId());
    }

    public void deleteUserNotifications(long userId, Collection<Long> notificationIds) {
        Reactive.multiple().registerConsumers(notificationIds, it -> this.deleteUserNotification(userId, (long)it, false)).blockingExecute();
    }

    public NotificationModel getUserNotification(long userId, long notificationId) {
        NotificationReceiver notificationReceiver = this.notificationReceiverRepository.findByNotificationIdAndToUserId(notificationId, userId);
        if (notificationReceiver == null) {
            return null;
        }
        Notification notification = (Notification)this.notificationRepository.findById(notificationId);
        if (notification == null) {
            return null;
        }
        return this.entityToModelConverter.toModel(notification, notificationReceiver, false);
    }

    public long countUserUnreadNotifications(long userId) {
        return this.notificationReceiverRepository.countUnreadNotificationsByToUserId(userId);
    }

    private void doUpdateNotificationByRead(NotificationReceiver notificationReceiver) {
        if (notificationReceiver.getReadAt() == null) {
            LocalDateTime now = this.clock.nowDateTime();
            if (notificationReceiver.getReceivedAt() == null) {
                notificationReceiver.setReceivedAt(now);
            }
            notificationReceiver.setReadAt(now);
            notificationReceiver.setStatus(NotificationStatus.READ.toString());
            this.notificationReceiverRepository.save(notificationReceiver);
        }
    }
}

