/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.properties.file.io;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public final class Dates {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = Dates.getDateTimeFormatter(Dates.getPattern());

    private Dates() {
    }

    public static LocalDate parseDate(String source, String pattern) {
        return Dates.parseDate(source, Dates.getDateTimeFormatter(pattern));
    }

    public static LocalDate parseDate(String source, DateTimeFormatter formatter) {
        return LocalDate.parse(source, formatter);
    }

    public static LocalDateTime parseDateTime(String source) {
        return Dates.parseDateTime(source, Dates.getDateTimeFormatter());
    }

    public static LocalDateTime parseDateTime(String source, DateTimeFormatter formatter) {
        return LocalDateTime.parse(source, formatter);
    }

    public static DateTimeFormatter getDateTimeFormatter() {
        return DATE_TIME_FORMATTER;
    }

    public static DateTimeFormatter getDateTimeFormatter(String pattern) {
        return DateTimeFormatter.ofPattern(pattern);
    }

    public static Date parse(String source) {
        return Dates.parse(source, Dates.getPattern());
    }

    public static Date parse(String source, String pattern) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(pattern);
            return formatter.parse(source);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getPattern() {
        return "yyyy-MM-dd'T'HH:mm:ss:SSS";
    }
}

