/*
 * Copyright 2025 youngmonkeys.org
 * 
 * Licensed under the ezyplatform, Version 1.0.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     https://youngmonkeys.org/licenses/ezyplatform-1.0.0.txt
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

CREATE TABLE IF NOT EXISTS `ezy_access_token_meta` (
    `id` bigint unsigned NOT NULL AUTO_INCREMENT,
    `target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL,
    `access_token` varchar(300) NOT NULL,
    `access_token_full` mediumtext COLLATE utf8mb4_unicode_520_ci,
    `parent_id` bigint unsigned DEFAULT 0,
    `token_type` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
    `algorithm` varchar(50) COLLATE utf8mb4_unicode_520_ci,
    `scope` mediumtext COLLATE utf8mb4_unicode_520_ci,
    `issuer` varchar(300) COLLATE utf8mb4_unicode_520_ci,
    `tenant_id` varchar(300) COLLATE utf8mb4_unicode_520_ci,
    `client_id` varchar(300) COLLATE utf8mb4_unicode_520_ci,
    `device_id` varchar(300) COLLATE utf8mb4_unicode_520_ci,
    `client_secret` varchar(300) COLLATE utf8mb4_unicode_520_ci,
    `grant_type` varchar(300) COLLATE utf8mb4_unicode_520_ci,
    `kid` VARCHAR(300) COLLATE utf8mb4_unicode_520_ci,
    `jwks_uri` VARCHAR(300) COLLATE utf8mb4_unicode_520_ci,
    `public_key` mediumtext COLLATE utf8mb4_unicode_520_ci,
    `private_key` mediumtext COLLATE utf8mb4_unicode_520_ci,
    `audience` mediumtext COLLATE utf8mb4_unicode_520_ci,
    `not_before` datetime NULL,
    `updated_at` datetime NOT NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY `key_identifier` (`target`, `access_token`),
    INDEX `index_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
