/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.io;

import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfox.entity.EzyObject;
import com.tvd12.ezyfox.function.EzyToObject;
import com.tvd12.ezyfox.io.EzyCollectionConverter;
import com.tvd12.ezyfox.io.EzyCollections;
import com.tvd12.ezyfox.io.EzyDataConverter;
import com.tvd12.ezyfox.io.EzyNumbersConverter;
import com.tvd12.ezyfox.io.EzyOutputTransformer;
import com.tvd12.ezyfox.security.EzyBase64;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EzySimpleCollectionConverter
implements EzyCollectionConverter {
    private static final long serialVersionUID = -6609590648831856878L;
    protected final EzyOutputTransformer outputTransformer;
    protected final Map<Class, EzyToObject> converters = this.defaultConverters();

    public EzySimpleCollectionConverter(EzyOutputTransformer outputTransformer) {
        this.outputTransformer = outputTransformer;
    }

    protected <T> T convert(Object value, Class type) {
        EzyToObject converter = this.converters.get(type);
        if (converter != null) {
            return (T)converter.transform(value);
        }
        throw new IllegalArgumentException("has no converter with: " + type);
    }

    @Override
    public <T> T toArray(Collection coll, Class type) {
        return this.convert(coll, type);
    }

    protected <T> T toArray(Object array, Class type) {
        if (array instanceof EzyArray) {
            return this.toArray(((EzyArray)array).toList(), type.getComponentType());
        }
        if (array instanceof Collection) {
            return this.toArray((Collection)array, type.getComponentType());
        }
        Object answer = this.outputTransformer.transform(array, type);
        return (T)answer;
    }

    private <T> T[] toArray(Iterable iterable, T[] array) {
        int count = 0;
        Class<?> arrayType = array.getClass().getComponentType();
        for (Object obj : iterable) {
            array[count++] = this.toArray(obj, arrayType);
        }
        return array;
    }

    private char[] toPrimitiveCharArray(Object value) {
        if (value instanceof byte[]) {
            return EzyDataConverter.byteArrayToCharArray((byte[])((byte[])value));
        }
        if (value instanceof EzyArray) {
            return (char[])((EzyArray)value).toArray(Character.TYPE);
        }
        return EzyNumbersConverter.numbersToPrimitiveChars((Collection)((Collection)value));
    }

    private Character[] toWrapperCharArray(Object value) {
        if (value instanceof byte[]) {
            return EzyDataConverter.toCharWrapperArray((byte[])((byte[])value));
        }
        if (value instanceof EzyArray) {
            return (Character[])((EzyArray)value).toArray(Character.class);
        }
        return EzyNumbersConverter.numbersToWrapperChars((Collection)((Collection)value));
    }

    private byte[] toPrimitiveByteArray(Object value) {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof EzyArray) {
            return (byte[])((EzyArray)value).toArray(Byte.TYPE);
        }
        if (value instanceof String) {
            return EzyBase64.decode((String)((String)value));
        }
        return EzyDataConverter.collectionToPrimitiveByteArray((Collection)((Collection)value));
    }

    private Byte[] toWrapperByteArray(Object value) {
        if (value instanceof byte[]) {
            return EzyDataConverter.toByteWrapperArray((byte[])((byte[])value));
        }
        if (value instanceof EzyArray) {
            return (Byte[])((EzyArray)value).toArray(Byte.class);
        }
        if (value instanceof String) {
            return EzyDataConverter.toByteWrapperArray((byte[])EzyBase64.decode((String)((String)value)));
        }
        return EzyDataConverter.collectionToWrapperByteArray((Collection)((Collection)value));
    }

    private Map<Class, EzyToObject> defaultConverters() {
        ConcurrentHashMap<Class, EzyToObject> converters = new ConcurrentHashMap<Class, EzyToObject>();
        this.addDefaultConverters(converters);
        this.addCustomConverters(converters);
        return converters;
    }

    private void addDefaultConverters(Map<Class, EzyToObject> converters) {
        converters.put(Boolean.TYPE, EzyDataConverter::collectionToPrimitiveBoolArray);
        converters.put(Byte.TYPE, EzyNumbersConverter::numbersToPrimitiveBytes);
        converters.put(Character.TYPE, EzyNumbersConverter::numbersToPrimitiveChars);
        converters.put(Double.TYPE, EzyNumbersConverter::numbersToPrimitiveDoubles);
        converters.put(Float.TYPE, EzyNumbersConverter::numbersToPrimitiveFloats);
        converters.put(Integer.TYPE, EzyNumbersConverter::numbersToPrimitiveInts);
        converters.put(Long.TYPE, EzyNumbersConverter::numbersToPrimitiveLongs);
        converters.put(Short.TYPE, EzyNumbersConverter::numbersToPrimitiveShorts);
        converters.put(String.class, EzyDataConverter::collectionToStringArray);
        converters.put(Boolean.class, EzyDataConverter::collectionToWrapperBoolArray);
        converters.put(Byte.class, EzyNumbersConverter::numbersToWrapperBytes);
        converters.put(Character.class, EzyNumbersConverter::numbersToWrapperChars);
        converters.put(Double.class, EzyNumbersConverter::numbersToWrapperDoubles);
        converters.put(Float.class, EzyNumbersConverter::numbersToWrapperFloats);
        converters.put(Integer.class, EzyNumbersConverter::numbersToWrapperInts);
        converters.put(Long.class, EzyNumbersConverter::numbersToWrapperLongs);
        converters.put(Short.class, EzyNumbersConverter::numbersToWrapperShorts);
        converters.put(EzyObject.class, input -> (EzyObject[])EzyCollections.toArray((Collection)input, EzyObject[]::new));
    }

    private void addCustomConverters(Map<Class, EzyToObject> converters) {
        converters.put(boolean[].class, input -> (boolean[][])this.toArray((Iterable)input, (T[])new boolean[input.size()][]));
        converters.put(byte[].class, input -> {
            int count = 0;
            byte[][] answer = new byte[input.size()][];
            for (Object item : input) {
                answer[count++] = this.toPrimitiveByteArray(item);
            }
            return answer;
        });
        converters.put(char[].class, input -> {
            int count = 0;
            char[][] answer = new char[input.size()][];
            for (Object item : input) {
                answer[count++] = this.toPrimitiveCharArray(item);
            }
            return answer;
        });
        converters.put(double[].class, input -> (double[][])this.toArray((Iterable)input, (T[])new double[input.size()][]));
        converters.put(float[].class, input -> (float[][])this.toArray((Iterable)input, (T[])new float[input.size()][]));
        converters.put(int[].class, input -> (int[][])this.toArray((Iterable)input, (T[])new int[input.size()][]));
        converters.put(long[].class, input -> (long[][])this.toArray((Iterable)input, (T[])new long[input.size()][]));
        converters.put(short[].class, input -> (short[][])this.toArray((Iterable)input, (T[])new short[input.size()][]));
        converters.put(String[].class, input -> (String[][])this.toArray((Iterable)input, (T[])new String[input.size()][]));
        converters.put(Boolean[].class, input -> (Boolean[][])this.toArray((Iterable)input, (T[])new Boolean[input.size()][]));
        converters.put(Byte[].class, input -> {
            int count = 0;
            Byte[][] answer = new Byte[input.size()][];
            for (Object item : input) {
                answer[count++] = this.toWrapperByteArray(item);
            }
            return answer;
        });
        converters.put(Character[].class, input -> {
            int count = 0;
            Character[][] answer = new Character[input.size()][];
            for (Object item : input) {
                answer[count++] = this.toWrapperCharArray(item);
            }
            return answer;
        });
        converters.put(Double[].class, input -> (Double[][])this.toArray((Iterable)input, (T[])new Double[input.size()][]));
        converters.put(Float[].class, input -> (Float[][])this.toArray((Iterable)input, (T[])new Float[input.size()][]));
        converters.put(Integer[].class, input -> (Integer[][])this.toArray((Iterable)input, (T[])new Integer[input.size()][]));
        converters.put(Long[].class, input -> (Long[][])this.toArray((Iterable)input, (T[])new Long[input.size()][]));
        converters.put(Short[].class, input -> (Short[][])this.toArray((Iterable)input, (T[])new Short[input.size()][]));
    }
}

