/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.socket.data;

import com.tvd12.ezyfox.io.EzyStrings;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.constant.ISocketUserType;
import org.youngmonkeys.ezyplatform.constant.SocketUserType;

public class SocketUserData {
    private long userId;
    private long adminId;
    private String userUuid;
    private String adminUuid;
    private String userAccessToken;
    private String adminAccessToken;
    private ISocketUserType socketUserType;

    public boolean isAdmin() {
        return this.socketUserType == SocketUserType.ADMIN;
    }

    public boolean isAnonymous() {
        return this.socketUserType == SocketUserType.ANONYMOUS;
    }

    public boolean isUser() {
        return this.socketUserType == SocketUserType.USER;
    }

    public long getSocketUserId() {
        return this.adminId > 0L ? this.adminId : this.userId;
    }

    public String getSocketUserUuid() {
        return EzyStrings.isNotBlank((String)this.adminUuid) ? this.adminUuid : this.userUuid;
    }

    public String getSocketUserUuidIncludeType() {
        return this.socketUserType + "#" + this.getSocketUserUuid();
    }

    public SocketUserType getSocketUserTypeCast() {
        return (SocketUserType)this.socketUserType;
    }

    @Generated
    SocketUserData(long userId, long adminId, String userUuid, String adminUuid, String userAccessToken, String adminAccessToken, ISocketUserType socketUserType) {
        this.userId = userId;
        this.adminId = adminId;
        this.userUuid = userUuid;
        this.adminUuid = adminUuid;
        this.userAccessToken = userAccessToken;
        this.adminAccessToken = adminAccessToken;
        this.socketUserType = socketUserType;
    }

    @Generated
    public static SocketUserDataBuilder builder() {
        return new SocketUserDataBuilder();
    }

    @Generated
    public long getUserId() {
        return this.userId;
    }

    @Generated
    public long getAdminId() {
        return this.adminId;
    }

    @Generated
    public String getUserUuid() {
        return this.userUuid;
    }

    @Generated
    public String getAdminUuid() {
        return this.adminUuid;
    }

    @Generated
    public String getUserAccessToken() {
        return this.userAccessToken;
    }

    @Generated
    public String getAdminAccessToken() {
        return this.adminAccessToken;
    }

    @Generated
    public ISocketUserType getSocketUserType() {
        return this.socketUserType;
    }

    @Generated
    public static class SocketUserDataBuilder {
        @Generated
        private long userId;
        @Generated
        private long adminId;
        @Generated
        private String userUuid;
        @Generated
        private String adminUuid;
        @Generated
        private String userAccessToken;
        @Generated
        private String adminAccessToken;
        @Generated
        private ISocketUserType socketUserType;

        @Generated
        SocketUserDataBuilder() {
        }

        @Generated
        public SocketUserDataBuilder userId(long userId) {
            this.userId = userId;
            return this;
        }

        @Generated
        public SocketUserDataBuilder adminId(long adminId) {
            this.adminId = adminId;
            return this;
        }

        @Generated
        public SocketUserDataBuilder userUuid(String userUuid) {
            this.userUuid = userUuid;
            return this;
        }

        @Generated
        public SocketUserDataBuilder adminUuid(String adminUuid) {
            this.adminUuid = adminUuid;
            return this;
        }

        @Generated
        public SocketUserDataBuilder userAccessToken(String userAccessToken) {
            this.userAccessToken = userAccessToken;
            return this;
        }

        @Generated
        public SocketUserDataBuilder adminAccessToken(String adminAccessToken) {
            this.adminAccessToken = adminAccessToken;
            return this;
        }

        @Generated
        public SocketUserDataBuilder socketUserType(ISocketUserType socketUserType) {
            this.socketUserType = socketUserType;
            return this;
        }

        @Generated
        public SocketUserData build() {
            return new SocketUserData(this.userId, this.adminId, this.userUuid, this.adminUuid, this.userAccessToken, this.adminAccessToken, this.socketUserType);
        }

        @Generated
        public String toString() {
            return "SocketUserData.SocketUserDataBuilder(userId=" + this.userId + ", adminId=" + this.adminId + ", userUuid=" + this.userUuid + ", adminUuid=" + this.adminUuid + ", userAccessToken=" + this.userAccessToken + ", adminAccessToken=" + this.adminAccessToken + ", socketUserType=" + this.socketUserType + ")";
        }
    }
}

