/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.core.data;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.io.EzyStrings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultiValueMap {
    protected final Map<String, List<String>> map;

    public MultiValueMap(Map<String, List<String>> map) {
        this.map = map;
    }

    public static MultiValueMap of(Map<String, List<String>> map) {
        return new MultiValueMap(map);
    }

    public Set<String> keySets() {
        return this.map.keySet();
    }

    public String getValue(String key) {
        List<String> values = this.map.get(key);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    public String getValue(String key, String defaultValue) {
        String value = this.getValue(key);
        return value != null ? value : defaultValue;
    }

    public List<String> getValues(String key) {
        List<String> values = this.map.get(key);
        if (values == null) {
            return Collections.emptyList();
        }
        return values;
    }

    public Map<String, String> getValueMap(String name) {
        List<String> values = this.getValues(name);
        HashMap<String, String> map = new HashMap<String, String>();
        for (String item : values) {
            String[] kvs;
            if (EzyStrings.isNoContent((String)item)) continue;
            for (String kv : kvs = item.split(";")) {
                String[] strs = kv.split("=");
                String key = strs[0].trim();
                String value = strs.length <= 1 ? (kv.contains("=") ? "" : null) : strs[1];
                map.put(key, value);
            }
        }
        return map;
    }

    public String toString() {
        return this.map.toString();
    }

    public Map<String, String> toMap() {
        HashMap<String, String> answer = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : this.map.entrySet()) {
            String key = entry.getKey();
            List<String> values = entry.getValue();
            StringBuilder valueString = new StringBuilder();
            for (int i = 0; i < values.size(); ++i) {
                if (i > 0) {
                    valueString.append(";");
                }
                valueString.append(values.get(i));
            }
            answer.put(key, valueString.toString());
        }
        return answer;
    }

    public static List<String> mapToKeyValueList(Map<String, Object> map) {
        ArrayList<String> answer = new ArrayList<String>();
        for (Map.Entry<String, Object> e : map.entrySet()) {
            String key = e.getKey();
            Object value = e.getValue();
            if (value == null) {
                answer.add(key);
                continue;
            }
            answer.add(key + "=" + value);
        }
        return answer;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements EzyBuilder<MultiValueMap> {
        public final Map<String, List<String>> map = new HashMap<String, List<String>>();

        public Builder setValue(String key, String value) {
            this.map.computeIfAbsent(key, k -> new ArrayList()).add(value);
            return this;
        }

        public Builder setValues(String key, Iterable<String> values) {
            for (String value : values) {
                this.setValue(key, value);
            }
            return this;
        }

        public Builder setValues(String key, Map<String, Object> values) {
            return this.setValues(key, MultiValueMap.mapToKeyValueList(values));
        }

        public MultiValueMap build() {
            return new MultiValueMap(this.map);
        }
    }
}

