/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.core.net;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.io.EzyStrings;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class URIBuilder
implements EzyBuilder<URI> {
    protected List<String> paths;
    protected Map<String, String> queryParams;
    protected final StringBuilder builder;

    public URIBuilder() {
        this("");
    }

    public URIBuilder(String str) {
        this.builder = new StringBuilder(str);
    }

    public URIBuilder addPath(String path) {
        if (!EzyStrings.isEmpty((CharSequence)path)) {
            if (this.paths == null) {
                this.paths = new ArrayList<String>();
            }
            this.paths.add(path);
        }
        return this;
    }

    public URIBuilder addQueryParam(String name, String value) {
        if (this.queryParams == null) {
            this.queryParams = new HashMap<String, String>();
        }
        this.queryParams.put(name, value);
        return this;
    }

    public URIBuilder addQueryParamIfNotNull(String name, String value) {
        if (value != null) {
            this.addQueryParam(name, value);
        }
        return this;
    }

    public URI build() {
        String query;
        String path = this.buildPath();
        if (path != null) {
            this.builder.append(path);
        }
        if ((query = this.buildQuery()) != null) {
            this.builder.append("?").append(query);
        }
        return URI.create(this.builder.toString());
    }

    protected String buildPath() {
        if (this.paths == null) {
            return null;
        }
        String path = EzyStrings.join(this.paths, (String)"/");
        return URIBuilder.normalizePath(path);
    }

    protected String buildQuery() {
        if (this.queryParams == null) {
            return null;
        }
        int index = 0;
        int lastIndex = this.queryParams.size() - 1;
        StringBuilder b = new StringBuilder();
        for (String name : this.queryParams.keySet()) {
            String value = this.queryParams.get(name);
            b.append(name).append("=").append(value);
            if (index++ >= lastIndex) continue;
            b.append("&");
        }
        return b.toString();
    }

    public static String normalizePath(String path) {
        if (EzyStrings.isEmpty((CharSequence)path)) {
            return "";
        }
        int lastIndex = path.length() - 1;
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char ch = path.charAt(i);
            if (i < lastIndex) {
                char nextCh = path.charAt(i + 1);
                if (ch == '/' && nextCh == '/') continue;
            }
            b.append(ch);
        }
        return b.toString();
    }
}

