/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.codec;

import com.tvd12.ezyfox.codec.EzyByteToObjectDecoder;
import com.tvd12.ezyfox.codec.EzyDefaultDecodeHandlers;
import com.tvd12.ezyfox.codec.EzyMessage;
import com.tvd12.ezyfox.codec.EzyMessageDeserializer;
import java.nio.ByteBuffer;
import java.util.Queue;

public class MsgPackByteToObjectDecoder
implements EzyByteToObjectDecoder {
    protected final EzyDefaultDecodeHandlers handlers;
    protected final EzyMessageDeserializer deserializer;

    public MsgPackByteToObjectDecoder(EzyMessageDeserializer deserializer, int maxSize) {
        this.deserializer = deserializer;
        this.handlers = EzyDefaultDecodeHandlers.builder().maxSize(maxSize).build();
    }

    public Object decode(EzyMessage message) {
        return this.deserializer.deserialize(message.getContent());
    }

    public Object decode(EzyMessage message, byte[] decryptionKey) throws Exception {
        byte[] encryptedContent = message.getContent();
        if (message.getHeader().isEncrypted()) {
            encryptedContent = this.decryptMessageContent(encryptedContent, decryptionKey);
        }
        return this.deserializer.deserialize(encryptedContent);
    }

    public void decode(ByteBuffer bytes, Queue<EzyMessage> out) {
        this.handlers.handle(bytes, out);
    }

    protected byte[] decryptMessageContent(byte[] content, byte[] decryptionKey) throws Exception {
        return content;
    }

    public void reset() {
        this.handlers.reset();
    }
}

