/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.properties.file.annotation;

import com.tvd12.properties.file.annotation.Property;
import com.tvd12.properties.file.annotation.PropertyAnnotation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropertyAnnotations {
    private final List<Class> annotationClasses;
    private final Map<Class<?>, PropertyAnnotation> annotations = new HashMap();

    public PropertyAnnotations() {
        this.annotationClasses = new ArrayList<Class>();
        this.addPropertyAnnotation(new PropertyAnnotation(Property.class, a -> ((Property)a).value(), a -> ((Property)a).prefix()));
    }

    public String getPropertyName(Method method) {
        for (Class annotationClass : this.annotationClasses) {
            Object annotation = method.getAnnotation(annotationClass);
            if (annotation == null) continue;
            PropertyAnnotation ann = this.annotations.get(annotationClass);
            return ann.getPropertyName((Annotation)annotation);
        }
        return "";
    }

    public String getPropertyName(Field field) {
        for (Class annotationClass : this.annotationClasses) {
            Object annotation = field.getAnnotation(annotationClass);
            if (annotation == null) continue;
            PropertyAnnotation ann = this.annotations.get(annotationClass);
            return ann.getPropertyName((Annotation)annotation);
        }
        return "";
    }

    public String getPropertyPrefix(Method method) {
        for (Class annotationClass : this.annotationClasses) {
            Object annotation = method.getAnnotation(annotationClass);
            if (annotation == null) continue;
            PropertyAnnotation ann = this.annotations.get(annotationClass);
            return ann.getPropertyPrefix((Annotation)annotation);
        }
        return "";
    }

    public String getPropertyPrefix(Field field) {
        for (Class annotationClass : this.annotationClasses) {
            Object annotation = field.getAnnotation(annotationClass);
            if (annotation == null) continue;
            PropertyAnnotation ann = this.annotations.get(annotationClass);
            return ann.getPropertyPrefix((Annotation)annotation);
        }
        return "";
    }

    public void addPropertyAnnotation(PropertyAnnotation annotation) {
        if (this.annotations.containsKey(annotation.getAnnotationClass())) {
            return;
        }
        this.annotationClasses.add(annotation.getAnnotationClass());
        this.annotations.put(annotation.getAnnotationClass(), annotation);
    }

    public List<Class> getAnnotationClasses() {
        return this.annotationClasses;
    }
}

