/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.pagination;

import java.util.Map;
import java.util.function.Function;
import org.youngmonkeys.ezyplatform.model.UserMetaModel;
import org.youngmonkeys.ezyplatform.pagination.ComplexPaginationParameterConverter;
import org.youngmonkeys.ezyplatform.pagination.IdAscUserMetaPaginationParameter;
import org.youngmonkeys.ezyplatform.pagination.IdDescUserMetaPaginationParameter;
import org.youngmonkeys.ezyplatform.pagination.MetaNumberValueAscIdAscMetadataPaginationParameter;
import org.youngmonkeys.ezyplatform.pagination.MetaNumberValueDescIdDescMetadataPaginationParameter;
import org.youngmonkeys.ezyplatform.pagination.MetadataPaginationSortOrder;
import org.youngmonkeys.ezyplatform.pagination.PaginationParameterConverter;
import org.youngmonkeys.ezyplatform.pagination.UserMetaPaginationSortOrder;

public class UserMetaPaginationParameterConverter
extends ComplexPaginationParameterConverter<String, UserMetaModel> {
    public UserMetaPaginationParameterConverter(PaginationParameterConverter converter) {
        super(converter);
    }

    protected void mapPaginationParametersToTypes(Map<String, Class<?>> map) {
        map.put(UserMetaPaginationSortOrder.ID_ASC.toString(), IdAscUserMetaPaginationParameter.class);
        map.put(UserMetaPaginationSortOrder.ID_DESC.toString(), IdDescUserMetaPaginationParameter.class);
        map.put(MetadataPaginationSortOrder.META_NUMBER_VALUE_ASC_ID_ASC.toString(), MetaNumberValueAscIdAscMetadataPaginationParameter.class);
        map.put(MetadataPaginationSortOrder.META_NUMBER_VALUE_DESC_ID_DESC.toString(), MetaNumberValueDescIdDescMetadataPaginationParameter.class);
    }

    protected void addPaginationParameterExtractors(Map<String, Function<UserMetaModel, Object>> map) {
        map.put(UserMetaPaginationSortOrder.ID_ASC.toString(), model -> new IdAscUserMetaPaginationParameter(model.getId()));
        map.put(UserMetaPaginationSortOrder.ID_DESC.toString(), model -> new IdDescUserMetaPaginationParameter(model.getId()));
        map.put(MetadataPaginationSortOrder.META_NUMBER_VALUE_ASC_ID_ASC.toString(), model -> new MetaNumberValueAscIdAscMetadataPaginationParameter(model.getMetaNumberValue(), model.getId()));
        map.put(MetadataPaginationSortOrder.META_NUMBER_VALUE_DESC_ID_DESC.toString(), model -> new MetaNumberValueDescIdDescMetadataPaginationParameter(model.getMetaNumberValue(), model.getId()));
    }
}

